/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.ghost;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.camo.CamoContent;
import xfacthd.framedblocks.api.model.data.FramedBlockData;
import xfacthd.framedblocks.api.util.CamoList;
import xfacthd.framedblocks.api.util.Utils;

public interface GhostRenderBehaviour {
    @Nullable
    default public ItemStack getProxiedStack(ItemStack stack) {
        return null;
    }

    default public boolean mayRender(ItemStack stack, @Nullable ItemStack proxiedStack) {
        BlockItem item;
        Item item2 = stack.getItem();
        return item2 instanceof BlockItem && (item = (BlockItem)item2).getBlock() instanceof IFramedBlock;
    }

    default public int getPassCount(ItemStack stack, @Nullable ItemStack proxiedStack) {
        return 1;
    }

    @Nullable
    default public BlockState getRenderState(ItemStack stack, @Nullable ItemStack proxiedStack, BlockHitResult hit, BlockPlaceContext ctx, BlockState hitState, int renderPass) {
        Block block = ((BlockItem)stack.getItem()).getBlock();
        return block.getStateForPlacement(ctx);
    }

    default public BlockPos getRenderPos(ItemStack stack, @Nullable ItemStack proxiedStack, BlockHitResult hit, BlockPlaceContext ctx, BlockState hitState, BlockPos defaultPos, int renderPass) {
        return defaultPos;
    }

    default public boolean canRenderAt(ItemStack stack, @Nullable ItemStack proxiedStack, BlockHitResult hit, BlockPlaceContext ctx, BlockState hitState, BlockState renderState, BlockPos renderPos) {
        Player player;
        Level level = ctx.getLevel();
        return level.isUnobstructed(renderState, renderPos, CollisionContext.of((Entity)(player = Objects.requireNonNull(ctx.getPlayer())))) && level.getBlockState(renderPos).canBeReplaced(ctx);
    }

    default public CamoList readCamo(ItemStack stack, @Nullable ItemStack proxiedStack, int renderPass) {
        return (CamoList)stack.getOrDefault(Utils.DC_TYPE_CAMO_LIST, (Object)CamoList.EMPTY);
    }

    default public CamoList postProcessCamo(ItemStack stack, @Nullable ItemStack proxiedStack, BlockPlaceContext ctx, BlockState renderState, int renderPass, CamoList camo) {
        return camo;
    }

    default public ModelData buildModelData(ItemStack stack, @Nullable ItemStack proxiedStack, BlockPlaceContext ctx, BlockState renderState, int renderPass, CamoList camo) {
        return ModelData.builder().with(FramedBlockData.PROPERTY, (Object)new FramedBlockData((CamoContent<?>)camo.getCamo(0).getContent(), false)).build();
    }

    default public ModelData appendModelData(ItemStack stack, @Nullable ItemStack proxiedStack, BlockPlaceContext ctx, BlockState renderState, int renderPass, ModelData data) {
        return data;
    }
}

