/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.register;

import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.common.connection.FluxNetwork;
import sonar.fluxnetworks.common.connection.FluxNetworkData;
import sonar.fluxnetworks.common.data.FluxPlayerData;
import sonar.fluxnetworks.common.util.FluxCommands;
import sonar.fluxnetworks.common.util.FluxUtils;
import sonar.fluxnetworks.register.Channel;
import sonar.fluxnetworks.register.Messages;
import sonar.fluxnetworks.register.RegistryBlocks;
import sonar.fluxnetworks.register.RegistryItems;

@EventBusSubscriber(modid="fluxnetworks")
public class EventHandler {
    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        FluxNetworkData.release();
    }

    @SubscribeEvent
    public static void onServerTick(@Nonnull ServerTickEvent.Post event) {
        FluxNetworkData.getAllNetworks().forEach(FluxNetwork::onEndServerTick);
    }

    @SubscribeEvent(receiveCanceled=true)
    public static void onPlayerInteract(PlayerInteractEvent.LeftClickBlock event) {
        BlockState base;
        BlockPos pos;
        if (!FluxConfig.enableFluxRecipe || event.getLevel().isClientSide) {
            return;
        }
        ServerLevel level = (ServerLevel)event.getLevel();
        BlockState crusher = level.getBlockState(pos = event.getPos());
        if (crusher.getBlock() == Blocks.OBSIDIAN && ((base = level.getBlockState(pos.below(2))).getBlock() == Blocks.BEDROCK || base.getBlock() == RegistryBlocks.FLUX_BLOCK.get())) {
            ItemEntity entity2;
            List entities = level.getEntitiesOfClass(ItemEntity.class, new AABB(pos.below()));
            if (entities.isEmpty()) {
                return;
            }
            int itemCount = 0;
            for (ItemEntity entity2 : entities) {
                if (!entity2.getItem().is(Items.REDSTONE)) continue;
                entity2.discard();
                if ((itemCount += entity2.getItem().getCount()) < 512) continue;
                break;
            }
            if (itemCount == 0) {
                return;
            }
            ItemStack stack = new ItemStack((ItemLike)RegistryItems.FLUX_DUST.get(), itemCount);
            level.removeBlock(pos, false);
            entity2 = new ItemEntity((Level)level, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, stack);
            entity2.setNoPickUpDelay();
            entity2.setDeltaMovement(0.0, 0.2, 0.0);
            level.addFreshEntity((Entity)entity2);
            if (level.getRandom().nextDouble() > Math.pow(0.9, itemCount >> 3)) {
                level.setBlock(pos.below(), Blocks.COBBLESTONE.defaultBlockState(), 3);
                level.playSound(null, pos, SoundEvents.DRAGON_FIREBALL_EXPLODE, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                level.setBlock(pos.below(), crusher, 3);
                level.playSound(null, pos, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            int particleCount = Mth.clamp((int)(itemCount >> 2), (int)4, (int)64);
            level.sendParticles((ParticleOptions)ParticleTypes.LAVA, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, particleCount, 0.0, 0.0, 0.0, 0.0);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoined(@Nonnull PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity().level().isClientSide) {
            return;
        }
        Channel.get().sendToPlayer(Messages.updateNetwork(FluxNetworkData.getAllNetworks(), (byte)21), event.getEntity());
        Messages.syncCapability((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerClone(@Nonnull PlayerEvent.Clone event) {
        FluxPlayerData newData = FluxUtils.getPlayerData((ServerPlayer)event.getEntity());
        newData.copy(FluxUtils.getPlayerData((ServerPlayer)event.getOriginal()));
    }

    @SubscribeEvent
    public static void onRegisterCommands(@Nonnull RegisterCommandsEvent event) {
        FluxCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

