/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import sonar.fluxnetworks.api.FluxDataComponents;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.energy.EnergyType;
import sonar.fluxnetworks.client.ClientCache;
import sonar.fluxnetworks.common.block.FluxStorageBlock;
import sonar.fluxnetworks.common.connection.FluxNetwork;
import sonar.fluxnetworks.common.data.FluxDeviceConfigComponent;
import sonar.fluxnetworks.register.RegistryTags;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FluxDeviceItem
extends BlockItem {
    public FluxDeviceItem(Block block, Item.Properties props) {
        super(block, props);
    }

    public Component getName(ItemStack stack) {
        String value;
        Optional<String> customName;
        FluxDeviceConfigComponent component = (FluxDeviceConfigComponent)stack.get(FluxDataComponents.FLUX_CONFIG);
        if (component != null && (customName = component.customName()).isPresent() && !(value = customName.get()).isEmpty()) {
            return Component.literal((String)value);
        }
        return super.getName(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        FluxDeviceConfigComponent component = (FluxDeviceConfigComponent)stack.get(FluxDataComponents.FLUX_CONFIG);
        Long storedEnergy = (Long)stack.get(FluxDataComponents.STORED_ENERGY);
        if (component != null) {
            FluxNetwork network = ClientCache.getNetwork(component.networkId());
            if (network.isValid()) {
                tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + FluxTranslate.NETWORK_FULL_NAME.get() + ": " + String.valueOf(ChatFormatting.RESET) + network.getNetworkName())));
            }
            if (component.limit().isPresent()) {
                tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + FluxTranslate.TRANSFER_LIMIT.get() + ": " + String.valueOf(ChatFormatting.RESET) + EnergyType.FE.getStorage(component.getLimit()))));
            }
            if (component.priority().isPresent()) {
                tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + FluxTranslate.PRIORITY.get() + ": " + String.valueOf(ChatFormatting.RESET) + component.getPriority())));
            }
        }
        if (storedEnergy != null) {
            if (!stack.is(RegistryTags.FLUX_STORAGE)) {
                tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + FluxTranslate.INTERNAL_BUFFER.get() + ": " + String.valueOf(ChatFormatting.RESET) + EnergyType.FE.getStorage(storedEnergy))));
            } else {
                long energy = storedEnergy;
                Block block = this.getBlock();
                double percentage = block instanceof FluxStorageBlock ? Math.min((double)energy / (double)((FluxStorageBlock)block).getEnergyCapacity(), 1.0) : 0.0;
                tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + FluxTranslate.ENERGY_STORED.get() + ": " + String.valueOf(ChatFormatting.RESET) + EnergyType.FE.getStorage(energy) + String.format(" (%.1f%%)", percentage * 100.0))));
            }
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

