/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.gui.EnumNetworkColor;
import sonar.fluxnetworks.api.network.SecurityLevel;
import sonar.fluxnetworks.client.gui.EnumNavigationTab;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.button.ColorButton;
import sonar.fluxnetworks.client.gui.button.SimpleButton;
import sonar.fluxnetworks.client.gui.tab.GuiTabEditAbstract;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.register.ClientMessages;

public class GuiTabCreate
extends GuiTabEditAbstract {
    public SimpleButton mCreate;

    public GuiTabCreate(@Nonnull FluxMenu menu, @Nonnull Player player) {
        super(menu, player);
        this.mSecurityLevel = SecurityLevel.PRIVATE;
    }

    @Override
    public EnumNavigationTab getNavigationTab() {
        return EnumNavigationTab.TAB_CREATE;
    }

    @Override
    public void init() {
        super.init();
        this.mNetworkName.setValue(FluxTranslate.PLAYERS_NETWORK.format(this.mPlayer.getGameProfile().getName()));
        for (int i = 0; i < EnumNetworkColor.VALUES.length; ++i) {
            EnumNetworkColor color = EnumNetworkColor.VALUES[i];
            ColorButton button = new ColorButton(this, this.leftPos + 48 + i % 7 * 16, this.topPos + 87 + i / 7 * 16, color.getRGB());
            if (i == 0) {
                this.mColorButton = button;
                button.setSelected(true);
            }
            this.mButtons.add(button);
        }
        this.mCreate = new SimpleButton(this, this.leftPos + this.imageWidth / 2 - 24, this.topPos + 150, 48, 12, FluxTranslate.CREATE.get());
        this.mButtons.add(this.mCreate);
        this.onEditSettingsChanged();
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        super.drawForegroundLayer(gr, mouseX, mouseY, deltaTicks);
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, float mouseX, float mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && button == this.mCreate) {
            ClientMessages.createNetwork(this.getToken(), this.mNetworkName.getValue(), this.mColorButton.mColor, this.mSecurityLevel, this.mPassword.getValue());
            this.mCreate.setClickable(false);
        }
    }

    @Override
    public void onEditSettingsChanged() {
        if (this.mCreate != null) {
            this.mCreate.setClickable((this.mSecurityLevel != SecurityLevel.ENCRYPTED || !this.mPassword.getValue().isEmpty()) && !this.mNetworkName.getValue().isEmpty());
        }
    }

    @Override
    protected void onResponseAction(int key, int code) {
        super.onResponseAction(key, code);
        if (key == 1 && code == -1) {
            this.switchTab(EnumNavigationTab.TAB_SELECTION, false);
        }
    }
}

