/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.basic;

import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.client.ClientCache;
import sonar.fluxnetworks.client.gui.EnumNavigationTab;
import sonar.fluxnetworks.client.gui.GuiFluxAdminHome;
import sonar.fluxnetworks.client.gui.GuiFluxDeviceHome;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiFluxCore;
import sonar.fluxnetworks.client.gui.button.NavigationButton;
import sonar.fluxnetworks.client.gui.tab.GuiTabConnections;
import sonar.fluxnetworks.client.gui.tab.GuiTabCreate;
import sonar.fluxnetworks.client.gui.tab.GuiTabDetailedSelection;
import sonar.fluxnetworks.client.gui.tab.GuiTabMembers;
import sonar.fluxnetworks.client.gui.tab.GuiTabSelection;
import sonar.fluxnetworks.client.gui.tab.GuiTabSettings;
import sonar.fluxnetworks.client.gui.tab.GuiTabStatistics;
import sonar.fluxnetworks.client.gui.tab.GuiTabWireless;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.device.TileFluxDevice;
import sonar.fluxnetworks.common.item.ItemAdminConfigurator;
import sonar.fluxnetworks.register.RegistrySounds;

public abstract class GuiTabCore
extends GuiFluxCore {
    public GuiTabCore(@Nonnull FluxMenu menu, @Nonnull Player player) {
        super(menu, player);
    }

    @Override
    public void init() {
        super.init();
        for (EnumNavigationTab tab : EnumNavigationTab.VALUES) {
            NavigationButton button = tab != EnumNavigationTab.TAB_CREATE ? new NavigationButton(this, this.leftPos + 12 + 18 * tab.ordinal(), this.topPos - 16, tab) : new NavigationButton(this, this.leftPos + 148, this.topPos - 16, tab);
            button.setSelected(tab == this.getNavigationTab());
            this.mButtons.add(button);
        }
    }

    public abstract EnumNavigationTab getNavigationTab();

    @Override
    public void onButtonClicked(GuiButtonCore button, float mouseX, float mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && button instanceof NavigationButton) {
            this.switchTab(((NavigationButton)button).getTab(), true);
        }
    }

    protected void renderNavigationPrompt(GuiGraphics gr, @Nonnull FluxTranslate error, @Nonnull EnumNavigationTab tab) {
        gr.drawCenteredString(this.font, error.get(), this.width / 2, this.topPos + 16, -8355712);
        gr.pose().pushPose();
        gr.pose().scale(0.75f, 0.75f, 1.0f);
        gr.drawCenteredString(this.font, FluxTranslate.CLICK_ABOVE.format(String.valueOf(ChatFormatting.AQUA) + tab.getTranslatedName() + String.valueOf(ChatFormatting.RESET)), (int)((float)this.width / 2.0f / 0.75f), (int)(((float)this.topPos + 28.0f) / 0.75f), 0x808080);
        gr.pose().popPose();
    }

    protected boolean redirectNavigationPrompt(double mouseX, double mouseY, int mouseButton, @Nonnull EnumNavigationTab tab) {
        if (mouseButton == 0 && mouseX >= (double)(this.leftPos + 20) && mouseX < (double)(this.leftPos + 155) && mouseY >= (double)(this.topPos + 16) && mouseY < (double)(this.topPos + 36)) {
            this.switchTab(tab, false);
            return true;
        }
        return false;
    }

    protected final void switchTab(@Nonnull EnumNavigationTab tab, boolean playSound) {
        switch (tab) {
            case TAB_HOME: {
                if (((FluxMenu)this.menu).mProvider instanceof TileFluxDevice) {
                    this.getMinecraft().setScreen((Screen)new GuiFluxDeviceHome((FluxMenu)this.menu, this.mPlayer));
                    break;
                }
                if (((FluxMenu)this.menu).mProvider instanceof ItemAdminConfigurator.Provider) {
                    this.getMinecraft().setScreen((Screen)new GuiFluxAdminHome((FluxMenu)this.menu, this.mPlayer));
                    break;
                }
                this.onClose();
                break;
            }
            case TAB_SELECTION: {
                if (((FluxMenu)this.menu).mProvider instanceof ItemAdminConfigurator.Provider && ClientCache.sDetailedNetworkView && ClientCache.sSuperAdmin) {
                    this.getMinecraft().setScreen((Screen)new GuiTabDetailedSelection((FluxMenu)this.menu, this.mPlayer));
                    break;
                }
                this.getMinecraft().setScreen((Screen)new GuiTabSelection((FluxMenu)this.menu, this.mPlayer));
                break;
            }
            case TAB_WIRELESS: {
                this.getMinecraft().setScreen((Screen)new GuiTabWireless((FluxMenu)this.menu, this.mPlayer));
                break;
            }
            case TAB_CONNECTION: {
                this.getMinecraft().setScreen((Screen)new GuiTabConnections((FluxMenu)this.menu, this.mPlayer));
                break;
            }
            case TAB_STATISTICS: {
                this.getMinecraft().setScreen((Screen)new GuiTabStatistics((FluxMenu)this.menu, this.mPlayer));
                break;
            }
            case TAB_MEMBER: {
                this.getMinecraft().setScreen((Screen)new GuiTabMembers((FluxMenu)this.menu, this.mPlayer));
                break;
            }
            case TAB_SETTING: {
                this.getMinecraft().setScreen((Screen)new GuiTabSettings((FluxMenu)this.menu, this.mPlayer));
                break;
            }
            case TAB_CREATE: {
                this.getMinecraft().setScreen((Screen)new GuiTabCreate((FluxMenu)this.menu, this.mPlayer));
            }
        }
        if (playSound && FluxConfig.enableButtonSound) {
            this.getMinecraft().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)RegistrySounds.BUTTON_CLICK.get()), (float)1.0f));
        }
    }
}

