/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.fastbench.util;

import dev.shadowsoffire.fastbench.FastBench;
import dev.shadowsoffire.fastbench.util.CraftingInventoryExt;
import dev.shadowsoffire.fastbench.util.FastBenchUtil;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="fastbench")
public class SlotUpdateManager {
    private static final Map<CraftingInventoryExt, Runnable> UPDATES = new IdentityHashMap<CraftingInventoryExt, Runnable>();
    private static long serverTicks = 0L;

    public static void queueSlotUpdate(Level level, Player player, CraftingInventoryExt inv, ResultContainer result) {
        if (level.isClientSide) {
            return;
        }
        Runnable task = () -> FastBenchUtil.slotChangedCraftingGrid(level, player, inv, result);
        UPDATES.putIfAbsent(inv, task);
    }

    @SubscribeEvent
    public static void serverTick(ServerTickEvent.Post e) {
        if (++serverTicks % (long)FastBench.gridUpdateInterval == 0L) {
            UPDATES.values().forEach(Runnable::run);
            UPDATES.clear();
        }
    }

    @SubscribeEvent
    public static void stop(ServerStoppedEvent e) {
        UPDATES.clear();
    }
}

