/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.effect;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.GameRules;

public class NourishmentEffect
extends MobEffect {
    public NourishmentEffect() {
        super(MobEffectCategory.BENEFICIAL, 15971072);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (!entity.getCommandSenderWorld().isClientSide && entity instanceof Player) {
            boolean isPlayerHealingWithHunger;
            Player player = (Player)entity;
            FoodData foodData = player.getFoodData();
            boolean bl = isPlayerHealingWithHunger = player.level().getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION) && player.isHurt() && foodData.getFoodLevel() >= 18;
            if (!isPlayerHealingWithHunger) {
                float exhaustion = foodData.getExhaustionLevel();
                float reduction = Math.min(exhaustion, 4.0f);
                if (exhaustion > 0.0f) {
                    player.causeFoodExhaustion(-reduction);
                }
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

