/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TatamiMatBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<TatamiMatBlock> CODEC = TatamiMatBlock.simpleCodec(TatamiMatBlock::new);
    public static final EnumProperty<BedPart> PART = BlockStateProperties.BED_PART;
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public TatamiMatBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(PART, (Comparable)BedPart.FOOT));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    private static Direction getDirectionToOther(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.getOpposite();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PART});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing == TatamiMatBlock.getDirectionToOther((BedPart)stateIn.getValue(PART), (Direction)stateIn.getValue((Property)FACING))) {
            return stateIn.canSurvive((LevelReader)level, currentPos) && facingState.is((Block)this) && facingState.getValue(PART) != stateIn.getValue(PART) ? stateIn : Blocks.AIR.defaultBlockState();
        }
        return !stateIn.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return !level.isEmptyBlock(pos.below());
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos pairPos;
        BlockState pairState;
        BedPart part;
        if (!level.isClientSide && player.isCreative() && (part = (BedPart)state.getValue(PART)) == BedPart.FOOT && (pairState = level.getBlockState(pairPos = pos.relative(TatamiMatBlock.getDirectionToOther(part, (Direction)state.getValue((Property)FACING))))).getBlock() == this && pairState.getValue(PART) == BedPart.HEAD) {
            level.setBlock(pairPos, Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent(player, 2001, pairPos, Block.getId((BlockState)pairState));
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide) {
            BlockPos facingPos = pos.relative((Direction)state.getValue((Property)FACING));
            level.setBlock(facingPos, (BlockState)state.setValue(PART, (Comparable)BedPart.HEAD), 3);
            level.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        Direction facing = context.getHorizontalDirection();
        BlockPos pairPos = context.getClickedPos().relative(facing);
        BlockState pairState = context.getLevel().getBlockState(pairPos);
        if (pairState.canBeReplaced(context) && this.canSurvive(pairState, (LevelReader)level, pairPos)) {
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing);
        }
        return null;
    }
}

