/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class TatamiBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty PAIRED = BooleanProperty.create((String)"paired");

    public TatamiBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.DOWN)).setValue((Property)PAIRED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction face = context.getClickedFace();
        BlockPos targetPos = context.getClickedPos().relative(face.getOpposite());
        BlockState targetState = context.getLevel().getBlockState(targetPos);
        boolean pairing = false;
        if (context.getPlayer() != null && !context.getPlayer().isShiftKeyDown() && targetState.getBlock() == this && !((Boolean)targetState.getValue((Property)PAIRED)).booleanValue()) {
            pairing = true;
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace().getOpposite())).setValue((Property)PAIRED, (Comparable)Boolean.valueOf(pairing));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide) {
            if (placer != null && placer.isShiftKeyDown()) {
                return;
            }
            BlockPos facingPos = pos.relative((Direction)state.getValue((Property)FACING));
            BlockState facingState = level.getBlockState(facingPos);
            if (facingState.getBlock() == this && !((Boolean)facingState.getValue((Property)PAIRED)).booleanValue()) {
                level.setBlock(facingPos, (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)).getOpposite())).setValue((Property)PAIRED, (Comparable)Boolean.valueOf(true)), 3);
                level.blockUpdated(pos, Blocks.AIR);
                state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
            }
        }
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing.equals((Object)stateIn.getValue((Property)FACING)) && ((Boolean)stateIn.getValue((Property)PAIRED)).booleanValue() && level.getBlockState(facingPos).getBlock() != this) {
            return (BlockState)stateIn.setValue((Property)PAIRED, (Comparable)Boolean.valueOf(false));
        }
        return super.updateShape(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PAIRED});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

