/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.client.gui;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.SignEditScreen;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import vectorwing.farmersdelight.common.block.state.CanvasSign;
import vectorwing.farmersdelight.common.registry.ModAtlases;

public class CanvasSignEditScreen
extends SignEditScreen {
    @Nullable
    protected SignRenderer.SignModel signModel;
    @Nullable
    protected DyeColor dye;
    protected final boolean isFrontText;

    public CanvasSignEditScreen(SignBlockEntity signBlockEntity, boolean isFront, boolean isTextFilteringEnabled) {
        super(signBlockEntity, isFront, isTextFilteringEnabled);
        Block block = signBlockEntity.getBlockState().getBlock();
        if (block instanceof CanvasSign) {
            CanvasSign canvasSign = (CanvasSign)block;
            this.dye = canvasSign.getBackgroundColor();
        }
        this.isFrontText = isFront;
    }

    protected void init() {
        super.init();
        this.signModel = SignRenderer.createSignModel((EntityModelSet)this.minecraft.getEntityModels(), (WoodType)this.woodType);
    }

    protected void renderSignBackground(GuiGraphics guiGraphics, BlockState state) {
        if (this.signModel != null) {
            boolean flag = state.getBlock() instanceof StandingSignBlock;
            guiGraphics.pose().translate(0.0f, 31.0f, 0.0f);
            if (!this.isFrontText) {
                guiGraphics.pose().mulPose(Axis.YP.rotationDegrees(180.0f));
            }
            guiGraphics.pose().scale(62.500004f, 62.500004f, -62.500004f);
            Material material = ModAtlases.getCanvasSignMaterial(this.dye);
            VertexConsumer vertexconsumer = material.buffer((MultiBufferSource)guiGraphics.bufferSource(), arg_0 -> ((SignRenderer.SignModel)this.signModel).renderType(arg_0));
            this.signModel.stick.visible = flag;
            this.signModel.root.render(guiGraphics.pose(), vertexconsumer, 0xF000F0, OverlayTexture.NO_OVERLAY);
        }
    }
}

