/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor.BladeSpan;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor.RotorDescriptor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor.ShaftSection;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineRotorBearingEntity;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.model.data.ModelData;

public class RotorBearingEntityRenderer
implements BlockEntityRenderer<TurbineRotorBearingEntity> {
    public RotorBearingEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public AABB getRenderBoundingBox(TurbineRotorBearingEntity bearing) {
        return bearing.getRenderBoundingBox();
    }

    public boolean shouldRenderOffScreen(TurbineRotorBearingEntity te) {
        return true;
    }

    public void render(TurbineRotorBearingEntity bearing, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (!bearing.isMachineAssembled() || bearing.isTurbineInteriorInvisible()) {
            return;
        }
        RotorDescriptor descriptor = bearing.getRotorDescriptor();
        if (null == descriptor) {
            return;
        }
        BakedModel shaft = descriptor.ShaftModel.get();
        BakedModel blade = descriptor.BladeModel.get();
        VertexConsumer builder = buffer.getBuffer(Sheets.solidBlockSheet());
        stack.pushPose();
        descriptor.InitMatrix.accept(stack, Float.valueOf(RotorBearingEntityRenderer.getRotorAngle(bearing)));
        for (ShaftSection section : descriptor.Sections) {
            descriptor.accept(stack);
            ModRenderHelper.renderModel((BakedModel)shaft, (ModelData)section.ShaftModelData, (PoseStack)stack, (VertexConsumer)builder, (int)combinedLight, (int)combinedOverlay, null);
            for (BladeSpan bladeSpan : section.Blades) {
                stack.pushPose();
                for (int i = 0; i < bladeSpan.Length; ++i) {
                    bladeSpan.accept(stack);
                    ModRenderHelper.renderModel((BakedModel)blade, (ModelData)bladeSpan.BladeModelData, (PoseStack)stack, (VertexConsumer)builder, (int)combinedLight, (int)combinedOverlay, null);
                }
                stack.popPose();
            }
        }
        stack.popPose();
    }

    private static float getRotorAngle(TurbineRotorBearingEntity bearing) {
        long elapsedTime = System.currentTimeMillis() - ModRenderHelper.getLastRenderTime();
        float speed = ((Float)bearing.evalOnController(turbine -> Float.valueOf(turbine.getRotorSpeed() / 10.0f), Float.valueOf(0.0f))).floatValue();
        float angle = bearing.getRotorAngle();
        if (speed > 0.001f) {
            angle += speed * ((float)elapsedTime / 60000.0f) * 360.0f;
            bearing.setRotorAngle(angle %= 360.0f);
        }
        return angle;
    }
}

