/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.client.screen;

import it.zerono.mods.extremereactors.CommonLocations;
import it.zerono.mods.extremereactors.gamecontent.compat.patchouli.PatchouliCompat;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonMultiblockScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.MultiblockFluidizer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.client.screen.FluidizerIcons;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.container.FluidizerControllerContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.FluidizerControllerEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.FluidizerFluidInjectorEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.IFluidizerRecipe;
import it.zerono.mods.zerocore.base.CommonConstants;
import it.zerono.mods.zerocore.base.client.screen.BaseIcons;
import it.zerono.mods.zerocore.base.client.screen.control.CommonPanels;
import it.zerono.mods.zerocore.base.client.screen.control.EnergyBar;
import it.zerono.mods.zerocore.base.client.screen.control.FluidBar;
import it.zerono.mods.zerocore.base.client.screen.control.MachineStatusIndicator;
import it.zerono.mods.zerocore.base.client.screen.control.OnOff;
import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.Orientation;
import it.zerono.mods.zerocore.lib.client.gui.Padding;
import it.zerono.mods.zerocore.lib.client.gui.control.GaugeBar;
import it.zerono.mods.zerocore.lib.client.gui.control.ItemStackDisplay;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.control.PanelGroup;
import it.zerono.mods.zerocore.lib.client.gui.control.Static;
import it.zerono.mods.zerocore.lib.client.gui.control.SwitchButton;
import it.zerono.mods.zerocore.lib.client.gui.layout.FixedLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.TabularLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.Sprite;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.item.inventory.PlayerInventoryUsage;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IBindableData;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class FluidizerControllerScreen
extends CommonMultiblockScreen<MultiblockFluidizer, FluidizerControllerEntity, FluidizerControllerContainer> {
    private final IControl _energyBar;
    private final RecipePanel _recipePanel;
    private final OnOff _onOff;

    public FluidizerControllerScreen(FluidizerControllerContainer container, Inventory inventory, Component title) {
        super(container, inventory, PlayerInventoryUsage.None, title, FluidizerIcons::getMap);
        this.addPatchouliHelpButton(PatchouliCompat.HANDBOOK_ID, CommonLocations.FLUIDIZER.buildWithSuffix("part-controller"), 1);
        this.addRecipesButton(() -> this.displayFluidizerRecipes(), "gui.bigreactors.show_recipes.tooltip.title");
        this._energyBar = new EnergyBar((ModContainerScreen)this, "energyBar", EnergySystem.ForgeEnergy, container.getEnergyCapacity(), container.ENERGY_STORED, null);
        this._recipePanel = new RecipePanel();
        this._onOff = new OnOff((ModContainerScreen)this, (IBindableData)((FluidizerControllerContainer)this.getMenu()).ACTIVE, this::onActiveStateChanged, (Component)Component.translatable((String)"gui.bigreactors.fluidizer.controller.on.title"), (Component)Component.translatable((String)"gui.bigreactors.fluidizer.controller.off.title"));
    }

    @Override
    protected MachineStatusIndicator createStatusIndicator(FluidizerControllerContainer container) {
        return this.createFluidizerStatusIndicator(container.ACTIVE);
    }

    protected void onScreenCreate() {
        super.onScreenCreate();
        this.setContentLayoutEngine((ILayoutEngine)new VerticalLayoutEngine().setZeroMargins());
        Panel table = new Panel((ModContainerScreen)this, "table");
        TabularLayoutEngine.TabularLayoutHint hint = TabularLayoutEngine.hintBuilder().setVerticalAlignment(VerticalAlignment.Top).setPadding(Padding.get((int)0, (int)0, (int)1, (int)0)).build();
        table.setDesiredDimension(DesiredDimension.Width, 198);
        table.setLayoutEngine((ILayoutEngine)TabularLayoutEngine.builder().columns(5, new int[]{18, 11, 108, 11, 50}).rows(1).build());
        this._energyBar.setLayoutEngineHint((ILayoutEngine.ILayoutEngineHint)hint);
        table.addControl(this._energyBar);
        Panel verticalSeparator = CommonPanels.verticalSeparator((ModContainerScreen)this);
        verticalSeparator.setLayoutEngineHint((ILayoutEngine.ILayoutEngineHint)hint);
        table.addControl((IControl)verticalSeparator);
        this._recipePanel.setLayoutEngineHint((ILayoutEngine.ILayoutEngineHint)hint);
        table.addControl((IControl)this._recipePanel);
        verticalSeparator = CommonPanels.verticalSeparator((ModContainerScreen)this);
        verticalSeparator.setLayoutEngineHint((ILayoutEngine.ILayoutEngineHint)hint);
        table.addControl((IControl)verticalSeparator);
        Panel commandPanel = CommonPanels.verticalCommandPanel((ModContainerScreen)this);
        commandPanel.setLayoutEngineHint((ILayoutEngine.ILayoutEngineHint)hint);
        table.addControl((IControl)commandPanel);
        this._onOff.setLayoutEngineHint(FixedLayoutEngine.hint((int)0, (int)0, (int)50, (int)16));
        commandPanel.addControl((IControl)this._onOff);
        this.addControl((IControl)table);
    }

    private void onActiveStateChanged(SwitchButton button) {
        if (!this.isDataUpdateInProgress()) {
            this.sendCommandToServer(button.getActive() ? CommonConstants.COMMAND_ACTIVATE : CommonConstants.COMMAND_DEACTIVATE);
        }
    }

    private class RecipePanel
    extends PanelGroup<IFluidizerRecipe.Type> {
        private final FluidBar _outputFluidBar;
        private final IControl[] _solidIngredients;
        private final IControl[] _fluidIngredients;
        private final GaugeBar _leftProgressBar;
        private final GaugeBar _rightProgressBar;

        public RecipePanel() {
            super((ModContainerScreen)FluidizerControllerScreen.this, "recipes", (Enum[])IFluidizerRecipe.Type.values());
            this.setDesiredDimension(108, 84);
            FluidizerControllerContainer container = (FluidizerControllerContainer)FluidizerControllerScreen.this.getMenu();
            this.bindActivePanel((IBindableData)container.RECIPE_TYPE);
            container.RECIPE_PROGRESS.bind(this::setProgress);
            this._outputFluidBar = new FluidBar((ModContainerScreen)FluidizerControllerScreen.this, "outbar", container.getOutputCapacity(), container.FLUID_OUTPUT_STACK, (Supplier)BaseIcons.Bucket, "gui.bigreactors.fluidizer.controller.fluidbar.title", null);
            this._leftProgressBar = this.progressBar(true, FluidizerIcons.ProgressLeft, FluidizerIcons.ProgressLeftFilled);
            this._rightProgressBar = this.progressBar(false, FluidizerIcons.ProgressRight, FluidizerIcons.ProgressRightFilled);
            this._solidIngredients = new IControl[2];
            Arrays.setAll(this._solidIngredients, this::solidInputControl);
            this._fluidIngredients = new IControl[2];
            Arrays.setAll(this._fluidIngredients, this::fluidInputControl);
            this.setPanel(IFluidizerRecipe.Type.Invalid, this.noRecipePanel());
            this.setPanel(IFluidizerRecipe.Type.Solid, this.solidRecipePanel());
            this.setPanel(IFluidizerRecipe.Type.SolidMixing, this.solidMixingRecipePanel());
            this.setPanel(IFluidizerRecipe.Type.FluidMixing, this.fluidMixingRecipePanel());
            this.setActivePanel(IFluidizerRecipe.Type.Invalid);
        }

        private void setProgress(double progress) {
            this._leftProgressBar.setValue(progress);
            this._rightProgressBar.setValue(progress);
        }

        private GaugeBar progressBar(boolean left, Supplier<@NotNull ISprite> background, Supplier<@NotNull ISprite> filler) {
            GaugeBar bar = new GaugeBar((ModContainerScreen)FluidizerControllerScreen.this, left ? "sxprogress" : "dxprogress", 1.0, filler.get());
            bar.setDesiredDimension(24, 16);
            bar.setLayoutEngineHint((ILayoutEngine.ILayoutEngineHint)TabularLayoutEngine.hintBuilder().setPadding(Padding.get((int)0, (int)0, (int)18, (int)0)).build());
            bar.setBackground(background.get());
            bar.setOrientation(left ? Orientation.LeftToRight : Orientation.RightToLeft);
            return bar;
        }

        private IControl solidInputControl(int index) {
            ItemStackDisplay display = new ItemStackDisplay((ModContainerScreen)FluidizerControllerScreen.this, "solidInput" + index);
            display.setLayoutEngineHint((ILayoutEngine.ILayoutEngineHint)TabularLayoutEngine.hintBuilder().setPadding(Padding.get((int)0, (int)0, (int)18, (int)0)).build());
            display.bindStack(((FluidizerControllerContainer)FluidizerControllerScreen.this.getMenu()).getSolidInput(index));
            return display;
        }

        private IControl fluidInputControl(int index) {
            return new FluidBar((ModContainerScreen)FluidizerControllerScreen.this, "inputfluid" + index, FluidizerFluidInjectorEntity.MAX_CAPACITY, ((FluidizerControllerContainer)FluidizerControllerScreen.this.getMenu()).getFluidInput(index), Sprite.EMPTY_SUPPLIER, "gui.bigreactors.fluidizer.controller.inputfuel.title", null);
        }

        private Panel panel() {
            Panel p = new Panel((ModContainerScreen)FluidizerControllerScreen.this);
            p.setDesiredDimension(108, 84);
            p.setLayoutEngine((ILayoutEngine)TabularLayoutEngine.builder().columns(5, new int[]{18, 27, 18, 27, 18}).rows(1).build());
            return p;
        }

        private Panel noRecipePanel() {
            Panel p = this.panel();
            Static dummy = new Static((ModContainerScreen)FluidizerControllerScreen.this, 1, 1);
            p.addControl(new IControl[]{dummy, dummy, this._outputFluidBar});
            return p;
        }

        private Panel solidRecipePanel() {
            Panel p = this.panel();
            p.addControl(new IControl[]{this._solidIngredients[0], this._leftProgressBar, this._outputFluidBar});
            return p;
        }

        private Panel solidMixingRecipePanel() {
            Panel p = this.panel();
            p.addControl(new IControl[]{this._solidIngredients[0], this._leftProgressBar, this._outputFluidBar, this._rightProgressBar, this._solidIngredients[1]});
            return p;
        }

        private Panel fluidMixingRecipePanel() {
            Panel p = this.panel();
            p.addControl(new IControl[]{this._fluidIngredients[0], this._leftProgressBar, this._outputFluidBar, this._rightProgressBar, this._fluidIngredients[1]});
            return p;
        }
    }
}

