/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.client.screen;

import it.zerono.mods.extremereactors.CommonLocations;
import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.compat.patchouli.PatchouliCompat;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonIcons;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonMultiblockScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.MultiBlockEnergizer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.container.EnergizerControllerContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.part.EnergizerControllerEntity;
import it.zerono.mods.zerocore.base.client.screen.BaseScreenToolTipsBuilder;
import it.zerono.mods.zerocore.base.client.screen.control.BarsPanel;
import it.zerono.mods.zerocore.base.client.screen.control.CommonPanels;
import it.zerono.mods.zerocore.base.client.screen.control.EnergyBar;
import it.zerono.mods.zerocore.base.client.screen.control.InformationDisplay;
import it.zerono.mods.zerocore.base.client.screen.control.MachineStatusIndicator;
import it.zerono.mods.zerocore.base.client.screen.control.OnOff;
import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.control.SwitchButton;
import it.zerono.mods.zerocore.lib.client.gui.layout.AnchoredLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.sprite.SpriteTextureMap;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.item.inventory.PlayerInventoryUsage;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IBindableData;
import it.zerono.mods.zerocore.lib.text.TextHelper;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class EnergizerControllerScreen
extends CommonMultiblockScreen<MultiBlockEnergizer, EnergizerControllerEntity, EnergizerControllerContainer> {
    private final EnergyBar _energyBar;
    private final OnOff _onOff;
    private final InformationDisplay _infoDisplay;
    private final InformationDisplay _detailsDisplay;
    private EnergySystem _displaySystem;

    public EnergizerControllerScreen(EnergizerControllerContainer container, Inventory inventory, Component title) {
        super(container, inventory, PlayerInventoryUsage.None, title, () -> new SpriteTextureMap(CommonLocations.TEXTURES_GUI_MULTIBLOCK.buildWithSuffix("basic_background.png"), 256, 256));
        this.addPatchouliHelpButton(PatchouliCompat.HANDBOOK_ID, CommonLocations.ENERGIZER.buildWithSuffix("part-controller"), 1);
        this._displaySystem = EnergySystem.ForgeEnergy;
        this._energyBar = new EnergyBar((ModContainerScreen)this, "energyBar", EnergySystem.REFERENCE, container.getEnergyCapacity(), container.ENERGY_STORED, "gui.bigreactors.energizer.controller.energybar.tooltip.body");
        this._infoDisplay = new InformationDisplay((ModContainerScreen)this, "info", layout -> layout.columns(1).rows(3, new int[]{20, 20, 20}));
        this._infoDisplay.setDesiredDimension(DesiredDimension.Width, 106);
        this._infoDisplay.addInformationCell(builder -> builder.name("stored").bindText((IBindableData)container.ENERGY_STORED, value -> this._displaySystem.asHumanReadableNumber(value)).icon((Supplier)CommonIcons.PowerBattery).useTooltipsFrom((IControl)this._energyBar));
        this._infoDisplay.addInformationCell(builder -> builder.name("io").bindText((IBindableData)container.ENERGY_IO, value -> this._displaySystem.asHumanReadableNumber(value)).icon((Supplier)CommonIcons.EnergyRatioIcon).tooltips(new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.energizer.controller.io.tooltip.title").addTranslatableAsValue("gui.bigreactors.energizer.controller.io.tooltip.value").addEmptyLine().addTranslatable("gui.bigreactors.energizer.controller.io.tooltip.body").addBindableObjectAsValue((IBindableData)container.ENERGY_IO, value -> TextHelper.literal((String)(this._displaySystem.asHumanReadableNumber(value) + "/t")))));
        String capacity = this._displaySystem.asHumanReadableNumber(container.getEnergyCapacity());
        this._infoDisplay.addInformationCell(builder -> builder.name("capacity").text(capacity).icon((Supplier)CommonIcons.ButtonSensorOutputEnergyAmount).tooltips(new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.energizer.controller.capacity.tooltip.title").addTranslatableAsValue("gui.bigreactors.energizer.controller.capacity.tooltip.value", new Object[]{capacity}).addEmptyLine().addTranslatable("gui.bigreactors.energizer.controller.capacity.tooltip.body")));
        this._detailsDisplay = new InformationDisplay((ModContainerScreen)this, "details", layout -> layout.columns(2).rows(2, new int[]{20, 20}));
        this._detailsDisplay.addInformationCell(builder -> builder.name("input").bindText((IBindableData)container.ENERGY_LAST_INPUT, value -> this._displaySystem.asHumanReadableNumber(value)).icon((Supplier)CommonIcons.DirectionInput).tooltips(new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.energizer.controller.input.tooltip.title").addTranslatableAsValue("gui.bigreactors.energizer.controller.input.tooltip.value").addEmptyLine().addTranslatable("gui.bigreactors.energizer.controller.input.tooltip.body").addBindableObjectAsValue((IBindableData)container.ENERGY_LAST_INPUT, value -> TextHelper.literal((String)(this._displaySystem.asHumanReadableNumber(value) + "/t")))));
        this._detailsDisplay.addInformationCell(builder -> builder.name("output").bindText((IBindableData)container.ENERGY_LAST_OUTPUT, value -> this._displaySystem.asHumanReadableNumber(value)).icon((Supplier)CommonIcons.DirectionOutput).tooltips(new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.energizer.controller.output.tooltip.title").addTranslatableAsValue("gui.bigreactors.energizer.controller.output.tooltip.value").addEmptyLine().addTranslatable("gui.bigreactors.energizer.controller.output.tooltip.body").addBindableObjectAsValue((IBindableData)container.ENERGY_LAST_OUTPUT, value -> TextHelper.literal((String)(this._displaySystem.asHumanReadableNumber(value) + "/t")))));
        this._onOff = new OnOff((ModContainerScreen)this, 25, 16, (IBindableData)container.ACTIVE, this::onActiveStateChanged, (Component)TextHelper.translatable((String)"gui.bigreactors.energizer.controller.on.title"), (Component)TextHelper.translatable((String)"gui.bigreactors.energizer.controller.off.title"));
        this.setContentBounds(14, 0);
    }

    @Override
    protected MachineStatusIndicator createStatusIndicator(EnergizerControllerContainer container) {
        return this.createEnergizerStatusIndicator(container.ACTIVE);
    }

    protected void onScreenCreate() {
        super.onScreenCreate();
        this.setContentLayoutEngine((ILayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)new VerticalLayoutEngine().setZeroMargins()).setControlsSpacing(2)).setVerticalAlignment(VerticalAlignment.Top)).setHorizontalAlignment(HorizontalAlignment.Left));
        Panel commandPanel = CommonPanels.verticalCommandPanel((ModContainerScreen)this, (int)50);
        commandPanel.setLayoutEngine((ILayoutEngine)new AnchoredLayoutEngine().setZeroMargins());
        this._onOff.setLayoutEngineHint((ILayoutEngine.ILayoutEngineHint)AnchoredLayoutEngine.Anchor.Top);
        commandPanel.addControl((IControl)this._onOff);
        BarsPanel barsPanel = new BarsPanel((ModContainerScreen)this, "bars").add((IControl)this._energyBar).addVerticalSeparator().add((IControl)this._infoDisplay).addVerticalSeparator().add((IControl)commandPanel);
        this.addControl((IControl)barsPanel);
        this.addControl((IControl)CommonPanels.horizontalSeparator((ModContainerScreen)this, (int)this.getContentWidth()));
        this.addControl((IControl)this._detailsDisplay);
    }

    private void onActiveStateChanged(SwitchButton button) {
        this.sendCommandToServer(button.getActive() ? CommonConstants.COMMAND_ACTIVATE : CommonConstants.COMMAND_DEACTIVATE);
    }
}

