/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.fluidport;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.zerono.mods.extremereactors.api.IMapping;
import it.zerono.mods.extremereactors.api.coolant.FluidMappingsRegistry;
import it.zerono.mods.extremereactors.gamecontent.mekanism.IMekanismService;
import it.zerono.mods.zerocore.base.multiblock.part.AbstractMultiblockEntity;
import it.zerono.mods.zerocore.base.multiblock.part.io.IOPortBlockCapabilitySource;
import it.zerono.mods.zerocore.base.multiblock.part.io.fluid.AbstractFluidPortHandler;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.IoMode;
import it.zerono.mods.zerocore.lib.fluid.handler.FluidHandlerForwarder;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.EmptyFluidHandler;
import org.jetbrains.annotations.NotNull;

public class FluidPortHandlerMekanism<Controller extends AbstractCuboidMultiblockController<Controller>, Port extends AbstractMultiblockEntity<Controller>>
extends AbstractFluidPortHandler<Controller, Port>
implements IChemicalHandler {
    private static Map<Fluid, IMapping<Fluid, Chemical>> s_fluidToGas;
    private static Map<Chemical, IMapping<Chemical, Fluid>> s_gasToFluid;
    private final FluidHandlerForwarder _capabilityForwarder = new FluidHandlerForwarder((IFluidHandler)EmptyFluidHandler.INSTANCE);
    private final IOPortBlockCapabilitySource<Controller, Port, IChemicalHandler> _remoteCapabilitySource;

    public FluidPortHandlerMekanism(Port port) {
        super(port, IoMode.Passive);
        this._remoteCapabilitySource = new IOPortBlockCapabilitySource(port, Capabilities.CHEMICAL.block());
    }

    public int outputFluid(FluidStack stack) {
        IChemicalHandler consumer = (IChemicalHandler)this._remoteCapabilitySource.getCapability();
        if (null == consumer || this.isPassive()) {
            return 0;
        }
        return (int)consumer.insertChemical(FluidPortHandlerMekanism.getGasStack(stack), Action.EXECUTE).getAmount();
    }

    public int inputFluid(IFluidHandler destination, int maxAmount) {
        return 0;
    }

    public boolean isConnected() {
        return null != this._remoteCapabilitySource.getCapability();
    }

    public void onPortChanged() {
        this._remoteCapabilitySource.onPortChanged();
    }

    public void update(Function<@NotNull IoDirection, @NotNull IFluidHandler> handlerProvider) {
        this._capabilityForwarder.setHandler(handlerProvider.apply(IoDirection.Output));
    }

    public int getChemicalTanks() {
        return 1;
    }

    public ChemicalStack getChemicalInTank(int idx) {
        return 0 != idx ? ChemicalStack.EMPTY : FluidPortHandlerMekanism.getGasStack(this._capabilityForwarder.getFluidInTank(0));
    }

    public void setChemicalInTank(int idx, ChemicalStack stack) {
    }

    public long getChemicalTankCapacity(int idx) {
        return 0 == idx ? (long)this._capabilityForwarder.getTankCapacity(0) : 0L;
    }

    public boolean isValid(int idx, ChemicalStack stack) {
        return false;
    }

    public ChemicalStack insertChemical(int idx, ChemicalStack stack, Action action) {
        return stack;
    }

    public ChemicalStack extractChemical(int idx, long amount, Action action) {
        FluidStack currentStack = this._capabilityForwarder.getFluidInTank(0);
        if (0 != idx || currentStack.isEmpty()) {
            return ChemicalStack.EMPTY;
        }
        IMapping<Fluid, Chemical> fluidMapping = FluidPortHandlerMekanism.getFluidMapping(currentStack.getFluid());
        if (null == fluidMapping) {
            return ChemicalStack.EMPTY;
        }
        IMapping<Chemical, Fluid> gasMapping = FluidPortHandlerMekanism.getGasMapping(fluidMapping.getProduct());
        if (null == gasMapping) {
            return ChemicalStack.EMPTY;
        }
        int amountToRemove = gasMapping.getProductAmount((int)Math.min(amount, Integer.MAX_VALUE));
        FluidStack removed = this._capabilityForwarder.drain(amountToRemove, action.toFluidAction());
        return FluidPortHandlerMekanism.getGasStack(removed);
    }

    private static ChemicalStack getGasStack(FluidStack fluidStack) {
        return fluidStack.isEmpty() ? ChemicalStack.EMPTY : FluidPortHandlerMekanism.getGasStack(fluidStack.getFluid(), fluidStack.getAmount());
    }

    private static ChemicalStack getGasStack(Fluid fluid, int amount) {
        IMapping<Fluid, Chemical> mapping = FluidPortHandlerMekanism.getFluidMapping(fluid);
        return null != mapping ? new ChemicalStack(mapping.getProduct(), (long)mapping.getProductAmount(amount)) : ChemicalStack.EMPTY;
    }

    @Nullable
    private static IMapping<Fluid, Chemical> getFluidMapping(Fluid fluid) {
        if (null == s_fluidToGas) {
            FluidPortHandlerMekanism.buildMappings();
        }
        return s_fluidToGas.get(fluid);
    }

    @Nullable
    private static IMapping<Chemical, Fluid> getGasMapping(Chemical gas) {
        if (null == s_gasToFluid) {
            FluidPortHandlerMekanism.buildMappings();
        }
        return s_gasToFluid.get(gas);
    }

    private static void buildMappings() {
        s_fluidToGas = new Object2ObjectOpenHashMap(8);
        s_gasToFluid = new Object2ObjectOpenHashMap(8);
        CodeHelper.getMinecraftServer().ifPresent(server -> {
            ResourceLocation typeId = ResourceLocation.fromNamespaceAndPath((String)IMekanismService.SERVICE.getId(), (String)"rotary");
            RecipeType type = (RecipeType)BuiltInRegistries.RECIPE_TYPE.get(typeId);
            if (null != type) {
                server.getRecipeManager().getAllRecipesFor(type).stream().map(RecipeHolder::value).filter(RotaryRecipe::hasFluidToChemical).forEach(rotaryRecipe -> {
                    ChemicalStack gasStack = (ChemicalStack)rotaryRecipe.getChemicalOutputDefinition().get(0);
                    rotaryRecipe.getFluidInput().getRepresentations().stream().filter(fluidStack -> FluidMappingsRegistry.hasVaporFrom(fluidStack.getFluid())).forEach(fluidStack -> {
                        IMapping<Fluid, Chemical> mapping = IMapping.of(fluidStack.getFluid(), fluidStack.getAmount(), gasStack.getChemical(), (int)gasStack.getAmount());
                        s_fluidToGas.put(fluidStack.getFluid(), mapping);
                        s_gasToFluid.put(mapping.getProduct(), mapping.getReverse());
                    });
                });
            }
        });
    }
}

