/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.config;

import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.zerocore.lib.CodeHelper;
import java.util.Calendar;
import net.neoforged.neoforge.common.ModConfigSpec;

public class Client {
    public final ModConfigSpec.BooleanValue disableReactorParticles;
    public final ModConfigSpec.BooleanValue disableTurbineParticles;
    public final ModConfigSpec.BooleanValue disableApiTooltips;
    public final ModConfigSpec.BooleanValue disablePatchouliTweaks;
    public final boolean isValentinesDay;
    public final boolean disableReprocessorMorphingAnimation;

    Client(ModConfigSpec.Builder builder) {
        builder.comment("Client only settings").push("client");
        this.disableReactorParticles = builder.comment("If true, disables all particle effects in the Reactor.").translation("config.bigreactors.client.disablereactorparticles").define("disableReactorParticles", false);
        this.disableTurbineParticles = builder.comment("If true, disables all particle effects in the Turbine.").translation("config.bigreactors.client.disableturbineparticles").define("disableTurbineParticles", false);
        this.disableApiTooltips = builder.comment("If true, no (advanced) tooltips will be added to blocks and items that can be used inside the Reactor or Turbine or as a fuel source.").translation("config.bigreactors.client.disableapitooltips").define("disableApiTooltips", false);
        this.disablePatchouliTweaks = builder.comment("If true, no custom Patchouli components will be added and the book will stop to work correctly. Enable this if you are having problems with newer versions of Patchouli").translation("config.bigreactors.client.disablepatchoulitweaks").define("disablePatchouliTweaks", false);
        builder.pop();
        Calendar calendar = Calendar.getInstance();
        this.isValentinesDay = calendar.get(2) == 1 && calendar.get(5) == 14;
        this.disableReprocessorMorphingAnimation = CodeHelper.isModLoaded((String)"rubidium");
        if (this.disableReprocessorMorphingAnimation) {
            Log.LOGGER.warn(Log.REPROCESSOR, "The mod rubidium was detected: disabling morphing animation to avoid crashing while rendering.");
        }
    }
}

