/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.storage.advancedstorageblock;

import com.refinedmods.refinedstorage.common.api.storage.StorageBlockData;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.common.storage.AbstractStorageContainerMenu;
import com.refinedmods.refinedstorage.common.storage.StorageAccessor;
import com.refinedmods.refinedstorage.common.storage.StorageConfigurationContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlotType;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;

public class AdvancedStorageBlockContainerMenu
extends AbstractStorageContainerMenu
implements StorageAccessor {
    private static final int FILTER_SLOT_X = 8;
    private static final int FILTER_SLOT_Y = 20;
    private long stored;
    private long capacity;

    public AdvancedStorageBlockContainerMenu(MenuType<?> type, int windowId, Player player, StorageBlockData storageBlockData, ResourceFactory resourceFactory) {
        super(type, windowId);
        this.stored = storageBlockData.stored();
        this.capacity = storageBlockData.capacity();
        this.addSlots(player, ResourceContainerImpl.createForFilter((ResourceFactory)resourceFactory, (List)storageBlockData.resources()));
    }

    public AdvancedStorageBlockContainerMenu(MenuType<?> type, int syncId, Player player, ResourceContainer resourceContainer, StorageConfigurationContainer configContainer) {
        super(type, syncId, player, configContainer);
        this.addSlots(player, resourceContainer);
    }

    private void addSlots(Player player, ResourceContainer resourceContainer) {
        for (int i = 0; i < resourceContainer.size(); ++i) {
            this.addSlot(this.createFilterSlot(resourceContainer, i));
        }
        this.addPlayerInventory(player.getInventory(), 8, 141);
        this.transferManager.addFilterTransfer((Container)player.getInventory());
    }

    private Slot createFilterSlot(ResourceContainer resourceContainer, int i) {
        int x = 8 + 18 * i;
        return new ResourceSlot(resourceContainer, i, (Component)IdentifierUtil.createTranslation((String)"gui", (String)"storage.filter_help"), x, 20, ResourceSlotType.FILTER);
    }

    public double getProgress() {
        if (this.capacity == 0L) {
            return 0.0;
        }
        return (double)this.getStored() / (double)this.getCapacity();
    }

    public boolean hasCapacity() {
        return this.capacity > 0L;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getStored() {
        return this.stored;
    }
}

