/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.me;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.inventories.InternalInventory;
import appeng.api.inventories.ItemTransfer;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.blockentity.misc.InscriberRecipes;
import appeng.core.definitions.AEItems;
import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.CombinedInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.IAEItemFilter;
import com.glodblock.github.extendedae.common.tileentities.TileExInscriber;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InscriberThread {
    private static final int MAX_PROCESSING_STEPS = 200;
    @NotNull
    private final TileExInscriber host;
    private int processingTime = 0;
    private final AppEngInternalInventory topItemHandler;
    private final AppEngInternalInventory bottomItemHandler;
    private final AppEngInternalInventory sideItemHandler;
    private final InternalInventory inv;
    private final Map<InternalInventory, ItemStack> lastStacks;
    public final InternalInventory topItemHandlerExtern;
    public final InternalInventory bottomItemHandlerExtern;
    public final InternalInventory sideItemHandlerExtern;
    public final InternalInventory combinedItemHandlerExtern;
    private boolean smash;
    private int finalStep;
    private long clientStart;
    private InscriberRecipe cachedTask = null;

    public InscriberThread(@NotNull TileExInscriber host) {
        int DEFAULT_STACK_SIZE = 64;
        this.host = host;
        BaseFilter baseFilter = new BaseFilter();
        this.topItemHandler = new AppEngInternalInventory((InternalInventoryHost)this.host, 1, DEFAULT_STACK_SIZE, (IAEItemFilter)baseFilter);
        this.bottomItemHandler = new AppEngInternalInventory((InternalInventoryHost)this.host, 1, DEFAULT_STACK_SIZE, (IAEItemFilter)baseFilter);
        this.sideItemHandler = new AppEngInternalInventory((InternalInventoryHost)this.host, 2, DEFAULT_STACK_SIZE, (IAEItemFilter)baseFilter);
        this.inv = new CombinedInternalInventory(new InternalInventory[]{this.topItemHandler, this.bottomItemHandler, this.sideItemHandler});
        this.lastStacks = new IdentityHashMap<AppEngInternalInventory, ItemStack>(Map.of(this.topItemHandler, ItemStack.EMPTY, this.bottomItemHandler, ItemStack.EMPTY, this.sideItemHandler, ItemStack.EMPTY));
        AutomationFilter automationFilter = new AutomationFilter();
        this.topItemHandlerExtern = new FilteredInternalInventory((InternalInventory)this.topItemHandler, (IAEItemFilter)automationFilter);
        this.bottomItemHandlerExtern = new FilteredInternalInventory((InternalInventory)this.bottomItemHandler, (IAEItemFilter)automationFilter);
        this.sideItemHandlerExtern = new FilteredInternalInventory((InternalInventory)this.sideItemHandler, (IAEItemFilter)automationFilter);
        this.combinedItemHandlerExtern = new CombinedInternalInventory(new InternalInventory[]{this.topItemHandlerExtern, this.bottomItemHandlerExtern, this.sideItemHandlerExtern});
    }

    public void init() {
        this.lastStacks.put((InternalInventory)this.topItemHandler, this.topItemHandler.getStackInSlot(0));
        this.lastStacks.put((InternalInventory)this.bottomItemHandler, this.bottomItemHandler.getStackInSlot(0));
        this.lastStacks.put((InternalInventory)this.sideItemHandler, this.sideItemHandler.getStackInSlot(0));
    }

    public void setStackSize(int size) {
        this.topItemHandler.setMaxStackSize(0, size);
        this.bottomItemHandler.setMaxStackSize(0, size);
        this.sideItemHandler.setMaxStackSize(0, size);
        this.sideItemHandler.setMaxStackSize(1, size);
    }

    public boolean containsInv(InternalInventory inv) {
        return this.topItemHandler == inv || this.bottomItemHandler == inv || this.sideItemHandler == inv;
    }

    public void readFromStream(RegistryFriendlyByteBuf data) {
        boolean newSmash;
        boolean oldSmash = this.isSmash();
        if (oldSmash != (newSmash = data.readBoolean()) && newSmash) {
            this.setSmash(true);
        }
        for (int i = 0; i < this.inv.size(); ++i) {
            this.inv.setItemDirect(i, (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)data));
        }
        this.cachedTask = null;
    }

    public void writeToStream(RegistryFriendlyByteBuf data) {
        data.writeBoolean(this.isSmash());
        for (int i = 0; i < this.inv.size(); ++i) {
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)data, (Object)this.inv.getStackInSlot(i));
        }
    }

    public int getMaxProcessingTime() {
        return 200;
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    private void setProcessingTime(int processingTime) {
        this.processingTime = processingTime;
    }

    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        if (slot == 0) {
            boolean sameItemSameTags = ItemStack.isSameItemSameComponents((ItemStack)inv.getStackInSlot(0), (ItemStack)this.lastStacks.get(inv));
            this.lastStacks.put(inv, inv.getStackInSlot(0).copy());
            if (sameItemSameTags) {
                return;
            }
            this.setProcessingTime(0);
            this.cachedTask = null;
        }
        this.host.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
    }

    public boolean isSleep() {
        return !this.hasAutoExportWork() && !this.hasCraftWork();
    }

    private boolean hasAutoExportWork() {
        return !this.sideItemHandler.getStackInSlot(1).isEmpty() && this.host.getConfigManager().getSetting(Settings.AUTO_EXPORT) == YesNo.YES;
    }

    private boolean hasCraftWork() {
        InscriberRecipe task = this.getTask();
        if (task != null) {
            return this.sideItemHandler.insertItem(1, task.getResultItem().copy(), true).isEmpty();
        }
        this.setProcessingTime(0);
        return this.isSmash();
    }

    public boolean isSmash() {
        return this.smash;
    }

    public void setSmash(boolean smash) {
        if (smash && !this.smash) {
            this.setClientStart(System.currentTimeMillis());
        }
        this.smash = smash;
    }

    public long getClientStart() {
        return this.clientStart;
    }

    private void setClientStart(long clientStart) {
        this.clientStart = clientStart;
    }

    public TickRateModulation tick() {
        if (this.isSmash()) {
            ++this.finalStep;
            if (this.finalStep == 8) {
                ItemStack outputCopy;
                InscriberRecipe out = this.getTask();
                if (out != null && this.sideItemHandler.insertItem(1, outputCopy = out.getResultItem().copy(), false).isEmpty()) {
                    this.setProcessingTime(0);
                    if (out.getProcessType() == InscriberProcessType.PRESS) {
                        this.topItemHandler.extractItem(0, 1, false);
                        this.bottomItemHandler.extractItem(0, 1, false);
                    }
                    this.sideItemHandler.extractItem(0, 1, false);
                }
                this.host.saveChanges();
            } else if (this.finalStep == 16) {
                this.finalStep = 0;
                this.setSmash(false);
                this.host.markForUpdate();
            }
        } else if (this.hasCraftWork()) {
            this.host.getMainNode().ifPresent(grid -> {
                IEnergyService eg = grid.getEnergyService();
                TileExInscriber src = this.host;
                int speedFactor = switch (this.host.getUpgrades().getInstalledUpgrades((ItemLike)AEItems.SPEED_CARD)) {
                    default -> 2;
                    case 1 -> 3;
                    case 2 -> 5;
                    case 3 -> 10;
                    case 4 -> 50;
                };
                int powerConsumption = 10 * speedFactor;
                double powerThreshold = (double)powerConsumption - 0.01;
                double powerReq = this.host.extractAEPower(powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                if (powerReq <= powerThreshold) {
                    src = eg;
                    powerReq = eg.extractAEPower((double)powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                }
                if (powerReq > powerThreshold) {
                    src.extractAEPower(powerConsumption, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    this.setProcessingTime(this.getProcessingTime() + speedFactor);
                }
            });
            if (this.getProcessingTime() > this.getMaxProcessingTime()) {
                ItemStack outputCopy;
                this.setProcessingTime(this.getMaxProcessingTime());
                InscriberRecipe out = this.getTask();
                if (out != null && this.sideItemHandler.insertItem(1, outputCopy = out.getResultItem().copy(), true).isEmpty()) {
                    this.setSmash(true);
                    this.finalStep = 0;
                    this.host.markForUpdate();
                }
            }
        }
        if (this.pushOutResult()) {
            return TickRateModulation.URGENT;
        }
        return this.hasCraftWork() ? TickRateModulation.URGENT : (this.hasAutoExportWork() ? TickRateModulation.SLOWER : TickRateModulation.SLEEP);
    }

    private boolean pushOutResult() {
        if (!this.hasAutoExportWork()) {
            return false;
        }
        EnumSet<Direction> pushSides = EnumSet.allOf(Direction.class);
        if (this.host.isSeparateSides()) {
            pushSides.remove(this.host.getTop());
            pushSides.remove(this.host.getTop().getOpposite());
        }
        assert (this.host.getLevel() != null);
        for (Direction dir : pushSides) {
            ItemTransfer target = InternalInventory.wrapExternal((Level)this.host.getLevel(), (BlockPos)this.host.getBlockPos().relative(dir), (Direction)dir.getOpposite());
            if (target == null) continue;
            int startItems = this.sideItemHandler.getStackInSlot(1).getCount();
            this.sideItemHandler.insertItem(1, target.addItems(this.sideItemHandler.extractItem(1, 64, false)), false);
            int endItems = this.sideItemHandler.getStackInSlot(1).getCount();
            if (startItems == endItems) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public InscriberRecipe getTask() {
        if (this.cachedTask == null && this.host.getLevel() != null) {
            ItemStack input = this.sideItemHandler.getStackInSlot(0);
            ItemStack plateA = this.topItemHandler.getStackInSlot(0);
            ItemStack plateB = this.bottomItemHandler.getStackInSlot(0);
            if (input.isEmpty()) {
                return null;
            }
            this.cachedTask = InscriberRecipes.findRecipe((Level)this.host.getLevel(), (ItemStack)input, (ItemStack)plateA, (ItemStack)plateB, (boolean)true);
        }
        return this.cachedTask;
    }

    public class BaseFilter
    implements IAEItemFilter {
        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            if (slot == 1) {
                return true;
            }
            if ((inv == InscriberThread.this.topItemHandler || inv == InscriberThread.this.bottomItemHandler) && AEItems.NAME_PRESS.is(stack)) {
                return true;
            }
            if (inv == InscriberThread.this.sideItemHandler && (AEItems.NAME_PRESS.is(InscriberThread.this.topItemHandler.getStackInSlot(0)) || AEItems.NAME_PRESS.is(InscriberThread.this.bottomItemHandler.getStackInSlot(0)))) {
                return true;
            }
            ItemStack bot = InscriberThread.this.bottomItemHandler.getStackInSlot(0);
            ItemStack middle = InscriberThread.this.sideItemHandler.getStackInSlot(0);
            ItemStack top = InscriberThread.this.topItemHandler.getStackInSlot(0);
            if (inv == InscriberThread.this.bottomItemHandler) {
                bot = stack;
            }
            if (inv == InscriberThread.this.sideItemHandler) {
                middle = stack;
            }
            if (inv == InscriberThread.this.topItemHandler) {
                top = stack;
            }
            assert (InscriberThread.this.host.getLevel() != null);
            for (RecipeHolder holder : InscriberRecipes.getRecipes((Level)InscriberThread.this.host.getLevel())) {
                InscriberRecipe recipe = (InscriberRecipe)holder.value();
                if (!middle.isEmpty() && !recipe.getMiddleInput().test(middle)) continue;
                if (bot.isEmpty() && top.isEmpty()) {
                    return true;
                }
                if (!(bot.isEmpty() ? recipe.getTopOptional().test(top) || recipe.getBottomOptional().test(top) : (top.isEmpty() ? recipe.getBottomOptional().test(bot) || recipe.getTopOptional().test(bot) : recipe.getTopOptional().test(top) && recipe.getBottomOptional().test(bot) || recipe.getBottomOptional().test(top) && recipe.getTopOptional().test(bot)))) continue;
                return true;
            }
            return false;
        }
    }

    public class AutomationFilter
    implements IAEItemFilter {
        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            if (slot == 1) {
                return true;
            }
            if (InscriberThread.this.isSmash()) {
                return false;
            }
            return InscriberThread.this.host.isSeparateSides() && (inv == InscriberThread.this.topItemHandler || inv == InscriberThread.this.bottomItemHandler);
        }

        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            if (slot == 1) {
                return false;
            }
            return !InscriberThread.this.isSmash();
        }
    }
}

