/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.gui;

import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.stacks.GenericStack;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ProgressBar;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.core.localization.Tooltips;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.interfaces.IProgressProvider;
import com.glodblock.github.extendedae.client.button.ActionEPPButton;
import com.glodblock.github.extendedae.client.button.EPPIcon;
import com.glodblock.github.extendedae.client.gui.subgui.OutputSideConfig;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.container.ContainerCrystalAssembler;
import com.glodblock.github.extendedae.network.EAENetworkHandler;
import com.glodblock.github.extendedae.network.packet.CEAEGenericPacket;
import com.glodblock.github.glodium.network.packet.IMessage;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class GuiCrystalAssembler
extends UpgradeableScreen<ContainerCrystalAssembler> {
    private final ProgressBar pb;
    private final SettingToggleButton<YesNo> autoExportBtn;
    private final ActionEPPButton outputSideBtn;

    public GuiCrystalAssembler(ContainerCrystalAssembler menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((UpgradeableMenu)menu, playerInventory, title, style);
        this.pb = new ProgressBar((IProgressProvider)this.menu, style.getImage("progressBar"), ProgressBar.Direction.VERTICAL);
        this.widgets.add("progressBar", (AbstractWidget)this.pb);
        this.autoExportBtn = new ServerSettingToggleButton(Settings.AUTO_EXPORT, (Enum)YesNo.NO);
        this.addToLeftToolbar((Button)this.autoExportBtn);
        this.outputSideBtn = new ActionEPPButton(b -> this.openOutputConfig(), EPPIcon.OUTPUT_SIDES);
        this.outputSideBtn.setMessage((Component)Component.translatable((String)"gui.extendedae.set_output_sides.open"));
        this.addToLeftToolbar((Button)this.outputSideBtn);
    }

    private void openOutputConfig() {
        if (((ContainerCrystalAssembler)this.getMenu()).getHost() != null) {
            this.switchToScreen((AEBaseScreen)new OutputSideConfig(this, new ItemStack((ItemLike)EAESingletons.CIRCUIT_CUTTER), (AEBaseBlockEntity)((ContainerCrystalAssembler)this.getMenu()).getHost(), ((ContainerCrystalAssembler)this.getMenu()).getOutputSides(), (side, value) -> EAENetworkHandler.INSTANCE.sendToServer((IMessage)new CEAEGenericPacket("set_side", side.getName(), value))));
        }
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        int progress = ((ContainerCrystalAssembler)this.menu).getCurrentProgress() * 100 / ((ContainerCrystalAssembler)this.menu).getMaxProgress();
        this.pb.setFullMsg((Component)Component.literal((String)(progress + "%")));
        this.autoExportBtn.set((Enum)((ContainerCrystalAssembler)this.getMenu()).getAutoExport());
        this.outputSideBtn.setVisibility(this.autoExportBtn.getCurrentValue() == YesNo.YES);
    }

    protected void renderTooltip(@NotNull GuiGraphics guiGraphics, int x, int y) {
        if (((ContainerCrystalAssembler)this.menu).getCarried().isEmpty() && this.isValidSlot(this.hoveredSlot)) {
            ArrayList<MutableComponent> itemTooltip = new ArrayList<MutableComponent>(this.getTooltipFromContainerItem(this.hoveredSlot.getItem()));
            GenericStack unwrapped = GenericStack.fromItemStack((ItemStack)this.hoveredSlot.getItem());
            long amt = unwrapped != null ? unwrapped.amount() : 0L;
            itemTooltip.add(Component.translatable((String)"gui.extendedae.crystal_assembler.amount", (Object[])new Object[]{amt, 16000}).withStyle(Tooltips.NORMAL_TOOLTIP_TEXT));
            this.drawTooltip(guiGraphics, x, y, itemTooltip);
        } else {
            super.renderTooltip(guiGraphics, x, y);
        }
    }

    private boolean isValidSlot(Slot slot) {
        return slot != null && slot.isActive() && slot.hasItem() && ((ContainerCrystalAssembler)this.menu).isTank(slot);
    }
}

