/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EndermanModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.level.block.state.BlockState;

public class ModCarriedBlockLayer<T extends EnderMan, M extends EndermanModel<T>>
extends RenderLayer<T, M> {
    private final BlockRenderDispatcher blockRenderer;

    public ModCarriedBlockLayer(RenderLayerParent<T, M> layer, BlockRenderDispatcher blockRenderer) {
        super(layer);
        this.blockRenderer = blockRenderer;
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        BlockState blockstate = livingEntity.getCarriedBlock();
        if (blockstate != null) {
            poseStack.pushPose();
            poseStack.translate(0.0, 0.6875, -0.75);
            poseStack.mulPose(Axis.XP.rotationDegrees(20.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(45.0f));
            poseStack.translate(0.25, 0.1875, 0.25);
            poseStack.scale(-0.5f, -0.5f, 0.5f);
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            this.blockRenderer.renderSingleBlock(blockstate, poseStack, buffer, packedLight, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
    }
}

