/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.epherolib.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;

public abstract class WorldBasedStorage {
    protected final Gson GSON;
    protected final Path basePath;

    public WorldBasedStorage(LevelResource resource, MinecraftServer server, String path) {
        this(server.getWorldPath(resource).resolve(path));
    }

    public WorldBasedStorage(Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.basePath = path;
        this.GSON = this.buildGson(new GsonBuilder());
    }

    protected abstract Gson buildGson(GsonBuilder var1);

    public Path getBasePath() {
        return this.basePath;
    }

    public void writeTagToFile(Tag tag, Path path) throws IOException {
        try (FileWriter writer = new FileWriter(path.toFile());){
            this.GSON.toJson((JsonElement)NbtOps.INSTANCE.convertTo((DynamicOps)JsonOps.INSTANCE, tag), (Appendable)writer);
        }
    }

    public Tag readTagFromFile(Path path) throws IOException {
        try (FileReader reader = new FileReader(path.toFile());){
            JsonElement jsonElement = (JsonElement)this.GSON.fromJson((Reader)reader, JsonElement.class);
            Tag tag = (Tag)JsonOps.INSTANCE.convertTo((DynamicOps)NbtOps.INSTANCE, jsonElement);
            return tag;
        }
    }

    public Stream<Path> getFiles() throws IOException {
        return Files.walk(this.basePath, new FileVisitOption[0]);
    }
}

