/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.item;

import dev.corgitaco.enhancedcelestials.entity.MeteorStrikeEntity;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MeteorStaffItem
extends Item {
    public MeteorStaffItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            CompoundTag itemStackTag = ((CustomData)itemstack.get(DataComponents.CUSTOM_DATA)).copyTag();
            if (!itemStackTag.contains("strike_id_for_charging", 3)) {
                BlockHitResult hitResult = MeteorStaffItem.getPlayerPOVHitResult(100.0, level, null, 0.0f, 1.0f, (LivingEntity)player, ClipContext.Fluid.NONE);
                if (hitResult.getType() != HitResult.Type.MISS) {
                    MeteorStrikeEntity meteorStrikeEntity = new MeteorStrikeEntity(level, hitResult.getLocation(), (Entity)player);
                    itemStackTag.putInt("strike_id_for_charging", meteorStrikeEntity.getId());
                    meteorStrikeEntity.setReady(false);
                    level.addFreshEntity((Entity)meteorStrikeEntity);
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                    return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
                }
            } else {
                player.startUsingItem(hand);
            }
            itemstack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)itemStackTag));
        }
        return super.use(level, player, hand);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int time) {
        CompoundTag tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag();
        if (tag.contains("strike_id_for_charging", 3)) {
            Entity meteorStrikeToCharge = level.getEntity(tag.getInt("strike_id_for_charging"));
            if (meteorStrikeToCharge instanceof MeteorStrikeEntity) {
                MeteorStrikeEntity meteorStrikeEntity = (MeteorStrikeEntity)meteorStrikeToCharge;
                meteorStrikeEntity.setReady(true);
            }
            tag.remove("strike_id_for_charging");
        }
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        super.releaseUsing(stack, level, entity, time);
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int count) {
        CompoundTag tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag();
        if (!level.isClientSide && tag.contains("strike_id_for_charging", 3)) {
            Entity meteorStrikeToCharge = level.getEntity(tag.getInt("strike_id_for_charging"));
            if (meteorStrikeToCharge instanceof MeteorStrikeEntity) {
                MeteorStrikeEntity meteorStrikeEntity = (MeteorStrikeEntity)meteorStrikeToCharge;
                BlockHitResult hitResult = MeteorStaffItem.getPlayerPOVHitResult(100.0, level, raytrace -> {
                    Vec3 velocity = entity.getEyePosition().subtract(raytrace).normalize().scale(-0.5);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, raytrace.x, raytrace.y, raytrace.z, 2, velocity.x, velocity.y, velocity.z, 0.01);
                    }
                }, 5.0f, 1.0f, entity, ClipContext.Fluid.NONE);
                if (meteorStrikeEntity.getBoundingBox().contains(hitResult.getLocation()) && meteorStrikeEntity.getSize() < 10.0f) {
                    meteorStrikeEntity.setSize(meteorStrikeEntity.getSize() + 0.1f);
                } else {
                    tag.remove("strike_id_for_charging");
                    meteorStrikeEntity.setReady(true);
                }
            } else {
                tag.remove("strike_id_for_charging");
            }
        }
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        super.onUseTick(level, entity, stack, count);
    }

    protected static BlockHitResult getPlayerPOVHitResult(double dist, Level level, @Nullable Consumer<Vec3> rayCastPosition, float distanceToStart, float rayTracePrecision, LivingEntity player, ClipContext.Fluid context) {
        float $$3 = player.getXRot();
        float $$4 = player.getYRot();
        Vec3 eyePosition = player.getEyePosition();
        float $$6 = Mth.cos((float)(-$$4 * ((float)Math.PI / 180) - (float)Math.PI));
        float $$7 = Mth.sin((float)(-$$4 * ((float)Math.PI / 180) - (float)Math.PI));
        float $$8 = -Mth.cos((float)(-$$3 * ((float)Math.PI / 180)));
        float $$9 = Mth.sin((float)(-$$3 * ((float)Math.PI / 180)));
        float $$10 = $$7 * $$8;
        float $$12 = $$6 * $$8;
        if (rayCastPosition != null) {
            for (double i = (double)distanceToStart; i < dist - 1.0; i += (double)rayTracePrecision) {
                rayCastPosition.accept(eyePosition.add((double)$$10 * i, (double)$$9 * i, (double)$$12 * i));
            }
        }
        return level.clip(new ClipContext(eyePosition, eyePosition.add((double)$$10 * dist, (double)$$9 * dist, (double)$$12 * dist), ClipContext.Block.COLLIDER, context, (Entity)player));
    }
}

