/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.datagen.providers;

import dev.corgitaco.enhancedcelestials.EnhancedCelestials;
import dev.corgitaco.enhancedcelestials.api.EnhancedCelestialsRegistry;
import dev.corgitaco.enhancedcelestials.api.lunarevent.DefaultLunarEvents;
import dev.corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class ECLunarEventTagsProvider
extends TagsProvider<LunarEvent> {
    private final boolean useMinecraftNameSpace;

    public ECLunarEventTagsProvider(PackOutput output, ResourceKey<? extends Registry<LunarEvent>> registryKey, CompletableFuture<HolderLookup.Provider> lookupProvider, boolean useMinecraftNameSpace) {
        super(output, registryKey, lookupProvider);
        this.useMinecraftNameSpace = useMinecraftNameSpace;
    }

    public ECLunarEventTagsProvider(PackOutput output, ResourceKey<? extends Registry<LunarEvent>> registryKey, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<LunarEvent>> parentProvider, boolean useMinecraftNameSpace) {
        super(output, registryKey, lookupProvider, parentProvider);
        this.useMinecraftNameSpace = useMinecraftNameSpace;
    }

    protected void addTags(HolderLookup.Provider pProvider) {
        this.tag(this.createTagKey("blood_moon")).add(new ResourceKey[]{DefaultLunarEvents.BLOOD_MOON, DefaultLunarEvents.SUPER_BLOOD_MOON});
        this.tag(this.createTagKey("blue_moon")).add(new ResourceKey[]{DefaultLunarEvents.BLUE_MOON, DefaultLunarEvents.SUPER_BLUE_MOON});
        this.tag(this.createTagKey("harvest_moon")).add(new ResourceKey[]{DefaultLunarEvents.HARVEST_MOON, DefaultLunarEvents.SUPER_HARVEST_MOON});
        this.tag(this.createTagKey("super_moon")).add(new ResourceKey[]{DefaultLunarEvents.SUPER_BLOOD_MOON, DefaultLunarEvents.SUPER_BLUE_MOON, DefaultLunarEvents.SUPER_HARVEST_MOON, DefaultLunarEvents.SUPER_MOON});
        this.tag(this.createTagKey("moon")).add(new ResourceKey[]{DefaultLunarEvents.BLOOD_MOON, DefaultLunarEvents.BLUE_MOON, DefaultLunarEvents.HARVEST_MOON, DefaultLunarEvents.DEFAULT});
    }

    public TagKey<LunarEvent> createTagKey(String path) {
        ResourceKey lunarEventKey = this.useMinecraftNameSpace ? ResourceKey.createRegistryKey((ResourceLocation)new ResourceLocation("lunar/event")) : EnhancedCelestialsRegistry.LUNAR_EVENT_KEY;
        return TagKey.create((ResourceKey)lunarEventKey, (ResourceLocation)EnhancedCelestials.createLocation(path));
    }

    public String getName() {
        return this.useMinecraftNameSpace ? "Fabric " + super.getName() : "Forge " + super.getName();
    }
}

