/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.corgitaco.enhancedcelestials.core.ECBlocks;
import dev.corgitaco.enhancedcelestials.entity.MeteorEntity;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;

public class MeteorEntityRenderer
extends EntityRenderer<MeteorEntity> {
    private static final int BIT_MASK = 31;

    public MeteorEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(MeteorEntity entity, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        float size = entity.getBbWidth();
        matrices.pushPose();
        float xzOffset = size * -0.5f;
        matrices.translate(xzOffset, 0.0f, xzOffset);
        matrices.scale(size, size, size);
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        BlockState state = ECBlocks.METEOR.get().defaultBlockState();
        VertexConsumer consumer = vertexConsumers.getBuffer(RenderType.solid());
        RandomSource source = RandomSource.create((long)state.getSeed(BlockPos.ZERO));
        UUID uuid = entity.getUUID();
        long most = uuid.getMostSignificantBits();
        long least = uuid.getLeastSignificantBits();
        dispatcher.renderBatched(state, BlockPos.ZERO, (BlockAndTintGetter)entity.level(), matrices, consumer, false, source);
        for (int i = 0; i < Math.max(Math.floorMod(least, 5), 1); ++i) {
            long random = most * (long)i;
            double x = (double)(random & 0x1FL) * 0.0325;
            double y = (double)(random >> 5 & 0x1FL) * 0.0325;
            double z = (double)(random >> 10 & 0x1FL) * 0.0325;
            matrices.pushPose();
            matrices.translate((random & 1L) == 1L ? x : z, (random >> 5 & 1L) == 1L ? y : x, (random >> 10 & 1L) == 1L ? z : y);
            dispatcher.renderBatched(state, BlockPos.ZERO, (BlockAndTintGetter)entity.level(), matrices, consumer, false, source);
            matrices.popPose();
        }
        matrices.popPose();
        super.render((Entity)entity, yaw, tickDelta, matrices, vertexConsumers, light);
    }

    public boolean shouldRender(MeteorEntity $$0, Frustum $$1, double $$2, double $$3, double $$4) {
        return true;
    }

    public ResourceLocation getTextureLocation(MeteorEntity meteorEntity) {
        return null;
    }
}

