/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.level.block;

import fuzs.enderzoology.world.entity.item.PrimedCharge;
import fuzs.enderzoology.world.level.EnderExplosionType;
import fuzs.puzzleslib.api.item.v2.ItemHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class ChargeBlock
extends TntBlock {
    private final EnderExplosionType enderExplosionType;

    public ChargeBlock(EnderExplosionType enderExplosionType, BlockBehaviour.Properties properties) {
        super(properties);
        this.enderExplosionType = enderExplosionType;
    }

    public void onCaughtFire(BlockState state, Level world, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        if (!world.isClientSide) {
            PrimedCharge primedtnt = new PrimedCharge(world, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, igniter, this.enderExplosionType);
            world.addFreshEntity((Entity)primedtnt);
            world.playSound(null, primedtnt.getX(), primedtnt.getY(), primedtnt.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.gameEvent((Entity)igniter, (Holder)GameEvent.PRIME_FUSE, pos);
        }
    }

    public void wasExploded(Level level, BlockPos pos, Explosion explosion) {
        if (!level.isClientSide) {
            PrimedCharge primedtnt = new PrimedCharge(level, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, explosion.getIndirectSourceEntity(), this.enderExplosionType);
            int fuse = primedtnt.getFuse();
            primedtnt.setFuse((short)(level.random.nextInt(fuse / 4) + fuse / 8));
            level.addFreshEntity((Entity)primedtnt);
        }
    }

    public void onPlace(BlockState pState, Level level, BlockPos blockPos, BlockState oldState, boolean movedByPiston) {
        if (!oldState.is(pState.getBlock()) && level.hasNeighborSignal(blockPos)) {
            this.onCaughtFire(pState, level, blockPos, null, null);
            level.removeBlock(blockPos, false);
        }
    }

    public void neighborChanged(BlockState blockState, Level level, BlockPos blockPos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (level.hasNeighborSignal(blockPos)) {
            this.onCaughtFire(blockState, level, blockPos, null, null);
            level.removeBlock(blockPos, false);
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        if (!level.isClientSide() && !player.isCreative() && ((Boolean)blockState.getValue((Property)UNSTABLE)).booleanValue()) {
            this.onCaughtFire(blockState, level, blockPos, null, null);
        }
        return super.playerWillDestroy(level, blockPos, blockState, player);
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult hitResult) {
        if (!itemStack.is(Items.FLINT_AND_STEEL) && !itemStack.is(Items.FIRE_CHARGE)) {
            return super.useItemOn(itemStack, blockState, level, blockPos, player, interactionHand, hitResult);
        }
        this.onCaughtFire(blockState, level, blockPos, hitResult.getDirection(), (LivingEntity)player);
        level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 11);
        Item item = itemStack.getItem();
        if (!player.isCreative()) {
            if (itemStack.is(Items.FLINT_AND_STEEL)) {
                ItemHelper.hurtAndBreak((ItemStack)itemStack, (int)1, (LivingEntity)player, (InteractionHand)interactionHand);
            } else {
                itemStack.shrink(1);
            }
        }
        player.awardStat(Stats.ITEM_USED.get((Object)item));
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void onProjectileHit(Level level, BlockState blockState, BlockHitResult hitResult, Projectile projectile) {
        if (!level.isClientSide) {
            BlockPos blockpos = hitResult.getBlockPos();
            Entity entity = projectile.getOwner();
            if (projectile.isOnFire() && projectile.mayInteract(level, blockpos)) {
                this.onCaughtFire(blockState, level, blockpos, null, entity instanceof LivingEntity ? (LivingEntity)entity : null);
                level.removeBlock(blockpos, false);
            }
        }
    }
}

