/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.level;

import fuzs.enderzoology.init.ModRegistry;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class EnderTeleportHelper {
    public static void teleportEntity(ServerLevel level, LivingEntity entity, int teleportRange, boolean endermiteChance) {
        EnderTeleportHelper.teleportEntity(level, entity, teleportRange, endermiteChance, false);
    }

    public static void teleportEntity(ServerLevel level, LivingEntity entity, int teleportRange, boolean endermiteChance, boolean forceTeleport) {
        if (forceTeleport || !entity.getType().is(ModRegistry.CONCUSSION_IMMUNE_ENTITY_TYPE_TAG)) {
            for (int i = 0; i < 16; ++i) {
                double randomX = entity.getX() + (entity.getRandom().nextDouble() - 0.5) * (double)teleportRange * 2.0;
                double randomY = Mth.clamp((double)(entity.getY() + (double)(entity.getRandom().nextInt(teleportRange * 2) - teleportRange)), (double)level.getMinBuildHeight(), (double)(level.getMinBuildHeight() + level.getLogicalHeight() - 1));
                double randomZ = entity.getZ() + (entity.getRandom().nextDouble() - 0.5) * (double)teleportRange * 2.0;
                if (entity.isPassenger()) {
                    entity.stopRiding();
                }
                Vec3 vec3 = entity.position();
                if (!entity.randomTeleport(randomX, randomY, randomZ, true)) continue;
                level.gameEvent((Holder)GameEvent.TELEPORT, vec3, GameEvent.Context.of((Entity)entity));
                SoundEvent soundEvent = EnderTeleportHelper.getEntityTeleportSound((Entity)entity);
                level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), soundEvent, entity.getSoundSource(), 1.0f, 1.0f);
                entity.playSound(soundEvent, 1.0f, 1.0f);
                if (endermiteChance && level.random.nextFloat() < 0.05f && level.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
                    Endermite endermite = (Endermite)EntityType.ENDERMITE.create((Level)level);
                    endermite.moveTo(vec3.x, vec3.y, vec3.z, entity.getYRot(), entity.getXRot());
                    level.addFreshEntity((Entity)endermite);
                }
                return;
            }
        }
    }

    private static SoundEvent getEntityTeleportSound(Entity entity) {
        if (entity instanceof Fox) {
            return SoundEvents.FOX_TELEPORT;
        }
        if (entity instanceof Shulker) {
            return SoundEvents.SHULKER_TELEPORT;
        }
        if (entity instanceof EnderMan) {
            return SoundEvents.ENDERMAN_TELEPORT;
        }
        return SoundEvents.CHORUS_FRUIT_TELEPORT;
    }
}

