/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.vehicle;

import fuzs.enderzoology.world.entity.item.PrimedCharge;
import fuzs.enderzoology.world.level.EnderExplosionHelper;
import fuzs.enderzoology.world.level.EnderExplosionType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class MinecartCharge
extends MinecartTNT {
    private EnderExplosionType enderExplosionType;

    public MinecartCharge(EntityType<? extends MinecartTNT> entityType, Level level) {
        super(entityType, level);
    }

    public MinecartCharge(EnderExplosionType enderExplosionType, Level level, double x, double y, double z) {
        this(enderExplosionType.getMinecartEntityType(), level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.enderExplosionType = enderExplosionType;
    }

    public AbstractMinecart.Type getMinecartType() {
        return this.enderExplosionType.getMinecartType();
    }

    public BlockState getDefaultDisplayBlockState() {
        return this.enderExplosionType.getChargeBlock().defaultBlockState();
    }

    protected Item getDropItem() {
        return this.enderExplosionType.getMinecartItem();
    }

    public ItemStack getPickResult() {
        return this.enderExplosionType.getMinecartItem().getDefaultInstance();
    }

    protected void explode(@Nullable DamageSource damageSource, double radiusModifier) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double radiusModifierSqrt = Math.sqrt(radiusModifier);
            if (radiusModifierSqrt > 5.0) {
                radiusModifierSqrt = 5.0;
            }
            EnderExplosionHelper.explode(serverLevel, (Entity)this, damageSource, this.getX(), this.getY(), this.getZ(), (float)(4.0 + this.random.nextDouble() * 1.5 * radiusModifierSqrt), Level.ExplosionInteraction.TNT, this.enderExplosionType, true);
            this.discard();
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte(PrimedCharge.TAG_ENTITY_INTERACTION, (byte)this.enderExplosionType.ordinal());
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.enderExplosionType = EnderExplosionType.values()[compound.getByte(PrimedCharge.TAG_ENTITY_INTERACTION)];
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, entity, this.enderExplosionType.ordinal());
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        this.enderExplosionType = EnderExplosionType.values()[packet.getData()];
    }
}

