/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.projectile;

import fuzs.enderzoology.init.ModEntityTypes;
import fuzs.enderzoology.init.ModItems;
import fuzs.enderzoology.world.entity.animal.Owl;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ThrownOwlEgg
extends ThrowableItemProjectile {
    public ThrownOwlEgg(EntityType<? extends ThrownOwlEgg> entityType, Level level) {
        super(entityType, level);
    }

    public ThrownOwlEgg(Level level, LivingEntity livingEntity) {
        super((EntityType)ModEntityTypes.OWL_EGG_ENTITY_TYPE.value(), livingEntity, level);
    }

    public ThrownOwlEgg(Level level, double d, double e, double f) {
        super((EntityType)ModEntityTypes.OWL_EGG_ENTITY_TYPE.value(), d, e, f, level);
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08);
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        result.getEntity().hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            if (this.random.nextInt(8) == 0) {
                Owl owl = (Owl)((EntityType)ModEntityTypes.OWL_ENTITY_TYPE.value()).create(this.level());
                owl.setAge(-24000);
                owl.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                this.level().addFreshEntity((Entity)owl);
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    protected Item getDefaultItem() {
        return (Item)ModItems.OWL_EGG_ITEM.value();
    }
}

