/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.monster;

import fuzs.enderzoology.world.level.EnderTeleportHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class InfestedZombie
extends Zombie {
    public InfestedZombie(EntityType<? extends InfestedZombie> entityType, Level level) {
        super(entityType, level);
    }

    protected boolean isSunSensitive() {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return null;
    }

    public void aiStep() {
        if (this.level().isClientSide) {
            for (int i = 0; i < 2; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getRandomX(0.5), this.getRandomY() - 0.25, this.getRandomZ(0.5), (this.random.nextDouble() - 0.5) * 2.0, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 2.0);
            }
        }
        super.aiStep();
    }

    public boolean doHurtTarget(Entity entity) {
        block4: {
            block5: {
                float localDifficulty;
                block6: {
                    if (!super.doHurtTarget(entity)) break block4;
                    localDifficulty = this.level().getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
                    if (!this.isAlive() || !(entity instanceof LivingEntity)) break block5;
                    if (!(entity instanceof Player)) break block6;
                    Player player = (Player)entity;
                    if (player.getAbilities().invulnerable) break block5;
                }
                if (this.random.nextFloat() < localDifficulty / 10.0f) {
                    EnderTeleportHelper.teleportEntity((ServerLevel)this.level(), (LivingEntity)entity, 8, false);
                }
            }
            return true;
        }
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (super.hurt(source, amount)) {
            if (this.isAlive() && (double)this.getHealth() < (double)this.getMaxHealth() * 0.5 && this.random.nextInt(4) == 0) {
                EnderTeleportHelper.teleportEntity((ServerLevel)this.level(), (LivingEntity)this, 8, false, true);
            }
            return true;
        }
        return false;
    }

    protected ItemStack getSkull() {
        return ItemStack.EMPTY;
    }
}

