/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.monster;

import fuzs.enderzoology.init.ModEntityTypes;
import fuzs.enderzoology.init.ModItems;
import fuzs.enderzoology.world.entity.ai.goal.RangedBowEasyAttackGoal;
import fuzs.puzzleslib.api.init.v3.registry.LookupHelper;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class FallenKnight
extends AbstractSkeleton {
    private static final Predicate<Difficulty> DOOR_BREAKING_PREDICATE = difficulty -> difficulty == Difficulty.HARD;
    private static final float BREAK_DOOR_CHANCE = 0.1f;
    private final BreakDoorGoal breakDoorGoal = new BreakDoorGoal((Mob)this, DOOR_BREAKING_PREDICATE);
    private RangedBowAttackGoal<AbstractSkeleton> bowGoal;
    private MeleeAttackGoal meleeGoal;
    private boolean canBreakDoors;

    public FallenKnight(EntityType<? extends AbstractSkeleton> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.getAvailableGoals().stream().map(WrappedGoal::getGoal).filter(goal -> goal instanceof AvoidEntityGoal).limit(1L).toList().forEach(arg_0 -> ((GoalSelector)this.goalSelector).removeGoal(arg_0));
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        this.populateArmorEquipmentSlots(random);
        Item item = random.nextBoolean() ? (Item)ModItems.HUNTING_BOW_ITEM.value() : (random.nextFloat() < (this.level().getDifficulty() == Difficulty.HARD ? 0.6f : 0.2f) ? Items.IRON_SWORD : Items.STONE_SWORD);
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)item));
    }

    private void populateArmorEquipmentSlots(RandomSource random) {
        float selector = random.nextFloat();
        int quality = selector < 0.1f ? 3 : (selector < 0.35f ? 0 : 2);
        EquipmentSlot[] values = EquipmentSlot.values();
        for (int i = values.length - 1; i >= 0; --i) {
            Item item;
            EquipmentSlot slot = values[i];
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            ItemStack itemStack = this.getItemBySlot(slot);
            if (slot != EquipmentSlot.HEAD && random.nextFloat() < (this.level().getDifficulty() == Difficulty.HARD ? 0.1f : 0.25f)) break;
            if (!itemStack.isEmpty() || (item = FallenKnight.getEquipmentForSlot((EquipmentSlot)slot, (int)quality)) == null) continue;
            this.setItemSlot(slot, new ItemStack((ItemLike)item));
        }
    }

    protected void enchantSpawnedWeapon(ServerLevelAccessor level, RandomSource random, DifficultyInstance difficulty) {
        ItemStack itemstack;
        super.enchantSpawnedWeapon(level, random, difficulty);
        if (random.nextInt(10) == 0 && (itemstack = this.getMainHandItem()).is((Item)ModItems.HUNTING_BOW_ITEM.value())) {
            Holder enchantment = LookupHelper.lookupEnchantment((LevelReader)level, (ResourceKey)Enchantments.PIERCING);
            itemstack.enchant(enchantment, 1);
            this.setItemSlot(EquipmentSlot.MAINHAND, itemstack);
        }
    }

    public boolean canFireProjectileWeapon(ProjectileWeaponItem projectileWeapon) {
        return projectileWeapon instanceof BowItem;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData) {
        spawnData = super.finalizeSpawn(level, difficulty, reason, spawnData);
        if (level.getRandom().nextBoolean()) {
            Mob fallenMount = (Mob)((EntityType)ModEntityTypes.FALLEN_MOUNT_ENTITY_TYPE.value()).create(this.level());
            fallenMount.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
            fallenMount.finalizeSpawn(level, difficulty, MobSpawnType.JOCKEY, null);
            this.startRiding((Entity)fallenMount);
            level.addFreshEntity((Entity)fallenMount);
        }
        this.setCanBreakDoors(level.getRandom().nextFloat() < difficulty.getSpecialMultiplier() * 0.1f);
        return spawnData;
    }

    public boolean canBreakDoors() {
        return this.canBreakDoors;
    }

    public void setCanBreakDoors(boolean canBreakDoors) {
        if (GoalUtils.hasGroundPathNavigation((Mob)this)) {
            if (this.canBreakDoors != canBreakDoors) {
                this.canBreakDoors = canBreakDoors;
                ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(canBreakDoors);
                if (canBreakDoors) {
                    this.goalSelector.addGoal(1, (Goal)this.breakDoorGoal);
                } else {
                    this.goalSelector.removeGoal((Goal)this.breakDoorGoal);
                }
            }
        } else if (this.canBreakDoors) {
            this.goalSelector.removeGoal((Goal)this.breakDoorGoal);
            this.canBreakDoors = false;
        }
    }

    public void reassessWeaponGoal() {
        if (this.level() != null && !this.level().isClientSide) {
            this.goalSelector.removeGoal((Goal)this.meleeGoal());
            this.goalSelector.removeGoal(this.bowGoal());
            ItemStack weaponStack = this.getCorrectBowWeapon(ItemStack.EMPTY);
            if (weaponStack.getItem() instanceof BowItem) {
                int i = 20;
                if (this.level().getDifficulty() != Difficulty.HARD) {
                    i = 40;
                }
                this.bowGoal().setMinAttackInterval(i);
                this.goalSelector.addGoal(4, this.bowGoal());
            } else {
                this.goalSelector.addGoal(4, (Goal)this.meleeGoal());
            }
        }
    }

    protected AbstractArrow getArrow(ItemStack arrow, float velocity, @Nullable ItemStack weaponStack) {
        return super.getArrow(arrow, velocity, this.getCorrectBowWeapon(weaponStack));
    }

    public ItemStack getProjectile(ItemStack weaponStack) {
        return super.getProjectile(this.getCorrectBowWeapon(weaponStack));
    }

    private ItemStack getCorrectBowWeapon(@Nullable ItemStack weaponStack) {
        if (weaponStack != null && (weaponStack.isEmpty() || weaponStack.is(Items.BOW))) {
            InteractionHand interactionHand = RangedBowEasyAttackGoal.getWeaponHoldingHand((LivingEntity)this, itemStack -> itemStack.getItem() instanceof BowItem);
            return this.getItemInHand(interactionHand);
        }
        return weaponStack;
    }

    private RangedBowAttackGoal<AbstractSkeleton> bowGoal() {
        if (this.bowGoal == null) {
            this.bowGoal = new RangedBowEasyAttackGoal<FallenKnight>(this, 1.0, 40, 60, 15.0f);
        }
        return this.bowGoal;
    }

    private MeleeAttackGoal meleeGoal() {
        if (this.meleeGoal == null) {
            this.meleeGoal = new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

                public void stop() {
                    super.stop();
                    FallenKnight.this.setAggressive(false);
                }

                public void start() {
                    super.start();
                    FallenKnight.this.setAggressive(true);
                }
            };
        }
        return this.meleeGoal;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.SKELETON_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SKELETON_DEATH;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.SKELETON_STEP;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("CanBreakDoors", this.canBreakDoors());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setCanBreakDoors(compound.getBoolean("CanBreakDoors"));
    }
}

