/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.ai.goal;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import org.jetbrains.annotations.Nullable;

public class FollowMobOwnerGoal
extends Goal {
    public static final int HORIZONTAL_SCAN_RANGE = 8;
    public static final int VERTICAL_SCAN_RANGE = 4;
    public static final int DONT_FOLLOW_IF_CLOSER_THAN = 3;
    private final Mob mob;
    private final Class<? extends Mob> ownerClazz;
    private final double speedModifier;
    @Nullable
    private Mob owner;
    private int timeToRecalcPath;

    public FollowMobOwnerGoal(Mob mob, Class<? extends Mob> ownerClazz, double speedModifier) {
        this.mob = mob;
        this.ownerClazz = ownerClazz;
        this.speedModifier = speedModifier;
    }

    public boolean canUse() {
        if (this.mob.getTarget() != null) {
            return false;
        }
        List list = this.mob.level().getEntitiesOfClass(this.ownerClazz, this.mob.getBoundingBox().inflate(8.0, 4.0, 8.0));
        Mob owner = null;
        double d = Double.MAX_VALUE;
        for (Mob animal2 : list) {
            double e = this.mob.distanceToSqr((Entity)animal2);
            if (e > d) continue;
            d = e;
            owner = animal2;
        }
        if (owner == null) {
            return false;
        }
        if (d < 9.0) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.mob.getTarget() != null) {
            return false;
        }
        if (!this.owner.isAlive()) {
            return false;
        }
        double d = this.mob.distanceToSqr((Entity)this.owner);
        return !(d < 9.0) && !(d > 256.0);
    }

    public void start() {
        this.timeToRecalcPath = 0;
    }

    public void stop() {
        this.owner = null;
    }

    public void tick() {
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.adjustedTickDelay(10);
            this.mob.getNavigation().moveTo((Entity)this.owner, this.speedModifier);
        }
    }
}

