/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.client.model;

import java.util.Optional;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.NonNullList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class FallenKnightModel<T extends Mob>
extends SkeletonModel<T> {
    public FallenKnightModel(ModelPart modelPart) {
        super(modelPart);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        Optional<Runnable> resetMainHand = FallenKnightModel.switchMainHandBow(entity);
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
        resetMainHand.ifPresent(Runnable::run);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        Optional<Runnable> resetMainHand = FallenKnightModel.switchMainHandBow(entity);
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        resetMainHand.ifPresent(Runnable::run);
    }

    private static <T extends Mob> Optional<Runnable> switchMainHandBow(T entity) {
        ItemStack stack = entity.getItemInHand(InteractionHand.MAIN_HAND);
        if (stack.getItem() instanceof BowItem && !stack.is(Items.BOW)) {
            FallenKnightModel.setMainHandItem(entity, new ItemStack((ItemLike)Items.BOW));
            return Optional.of(() -> FallenKnightModel.setMainHandItem(entity, stack));
        }
        return Optional.empty();
    }

    private static <T extends Mob> void setMainHandItem(T entity, ItemStack stack) {
        ((NonNullList)entity.getHandSlots()).set(EquipmentSlot.MAINHAND.getIndex(), (Object)stack);
    }
}

