/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.attachment;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import fuzs.enderzoology.attachment.CommandSourceHelper;
import fuzs.enderzoology.init.ModRegistry;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.init.v3.registry.LookupHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.commands.GiveCommand;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public record SoulboundItems(List<ItemStack> items) {
    public static final SoulboundItems EMPTY = new SoulboundItems(Collections.emptyList());
    public static final Codec<SoulboundItems> CODEC = ItemStack.CODEC.listOf().xmap(SoulboundItems::new, SoulboundItems::items);
    public static final StreamCodec<RegistryFriendlyByteBuf, SoulboundItems> STREAM_CODEC = ItemStack.LIST_STREAM_CODEC.map(SoulboundItems::new, SoulboundItems::items);

    public static EventResult onLivingDrops(LivingEntity entity, DamageSource damageSource, Collection<ItemEntity> drops, boolean recentlyHit) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            ModRegistry.SOULBOUND_ITEMS_ATTACHMENT_TYPE.set((Object)serverPlayer, (Object)SoulboundItems.saveOnDeath(serverPlayer, drops));
        }
        return EventResult.PASS;
    }

    public static SoulboundItems saveOnDeath(ServerPlayer serverPlayer, Collection<ItemEntity> drops) {
        Holder enchantment = LookupHelper.lookupEnchantment((Entity)serverPlayer, ModRegistry.SOULBOUND_ENCHANTMENT);
        List<ItemStack> items = drops.stream().filter(itemEntity -> EnchantmentHelper.getItemEnchantmentLevel((Holder)enchantment, (ItemStack)itemEntity.getItem()) > 0).toList().stream().peek(drops::remove).map(ItemEntity::getItem).map(ItemStack::copy).peek(itemStack -> {
            if (!serverPlayer.getAbilities().instabuild) {
                int enchantmentLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)enchantment, (ItemStack)itemStack);
                if (serverPlayer.getRandom().nextInt(enchantmentLevel) == 0) {
                    EnchantmentHelper.updateEnchantments((ItemStack)itemStack, enchantments -> enchantments.set(enchantment, enchantments.getLevel(enchantment) - 1));
                }
            }
        }).toList();
        return new SoulboundItems(items);
    }

    public static void onCopy(ServerPlayer originalPlayer, ServerPlayer newPlayer, boolean originalStillAlive) {
        if (!originalStillAlive) {
            ((SoulboundItems)ModRegistry.SOULBOUND_ITEMS_ATTACHMENT_TYPE.getOrDefault((Object)originalPlayer, (Object)EMPTY)).restoreAfterRespawn(newPlayer);
        }
    }

    public void restoreAfterRespawn(ServerPlayer serverPlayer) {
        CommandSourceStack commandSource = CommandSourceHelper.createEmptyCommandSource(serverPlayer.serverLevel());
        for (ItemStack itemStack : this.items) {
            ItemInput itemInput = new ItemInput(itemStack.getItemHolder(), itemStack.getComponentsPatch());
            try {
                GiveCommand.giveItem((CommandSourceStack)commandSource, (ItemInput)itemInput, Collections.singletonList(serverPlayer), (int)itemStack.getCount());
            }
            catch (CommandSyntaxException commandSyntaxException) {}
        }
    }
}

