/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.recipe;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.init.EnderStorageModContent;
import codechicken.lib.colour.EnumColour;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;

public class CreateRecipe
extends ShapedRecipe {
    public CreateRecipe(String group, ShapedRecipePattern pattern, ItemStack result) {
        super(group, CraftingBookCategory.MISC, pattern, result.copy(), true);
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registries) {
        EnumColour colour = EnumColour.WHITE;
        block0: for (int x = 0; x < inv.width(); ++x) {
            for (int y = 0; y < inv.height(); ++y) {
                EnumColour c;
                ItemStack stack = inv.getItem(x, y);
                if (stack.isEmpty() || (c = EnumColour.fromWoolStack((ItemStack)stack)) == null) continue;
                colour = c;
                break block0;
            }
        }
        Frequency frequency = new Frequency(colour, colour, colour);
        return frequency.writeToStack(super.assemble(inv, registries));
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)EnderStorageModContent.CREATE_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<CreateRecipe> {
        private static final MapCodec<CreateRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(e -> e.group), (App)ShapedRecipePattern.MAP_CODEC.forGetter(e -> e.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(e -> e.result)).apply((Applicative)builder, CreateRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, CreateRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, e -> e.group, (StreamCodec)ShapedRecipePattern.STREAM_CODEC, e -> e.pattern, (StreamCodec)ItemStack.STREAM_CODEC, e -> e.result, CreateRecipe::new);

        public MapCodec<CreateRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CreateRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

