/*
 * Decompiled with CFR 0.152.
 */
package fuzs.effectdescriptions.client.handler;

import com.google.common.collect.Lists;
import fuzs.effectdescriptions.EffectDescriptions;
import fuzs.effectdescriptions.client.helper.EffectLinesHelper;
import fuzs.effectdescriptions.config.ClientConfig;
import fuzs.puzzleslib.api.core.v1.Proxy;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class DescriptionTooltipHandler {
    public static void onItemTooltip(ItemStack itemStack, List<Component> lines, Item.TooltipContext tooltipContext, @Nullable Player player, TooltipFlag tooltipFlag) {
        if (!((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).itemDescription) {
            return;
        }
        if (!((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).supportedItems.contains((Object)itemStack.getItem()) && !itemStack.has(DataComponents.FOOD)) {
            return;
        }
        if (((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).shiftToReveal && !Screen.hasShiftDown()) {
            return;
        }
        Set ids = DescriptionTooltipHandler.getMobEffects(itemStack).stream().map(MobEffectInstance::getDescriptionId).collect(Collectors.toSet());
        if (!ids.isEmpty()) {
            int indentation = ((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).descriptionIndentation;
            for (int i = 0; i < lines.size(); ++i) {
                Component component2;
                Object object;
                PlainTextContents contents;
                ComponentContents componentContents;
                Component line = lines.get(i);
                while ((componentContents = line.getContents()) instanceof PlainTextContents && (contents = (PlainTextContents)componentContents).text().isBlank() && !line.getSiblings().isEmpty()) {
                    line = (Component)line.getSiblings().getFirst();
                }
                componentContents = line.getContents();
                if (!(componentContents instanceof TranslatableContents)) continue;
                contents = (TranslatableContents)componentContents;
                while (contents.getArgs().length != 0 && (object = contents.getArgs()[0]) instanceof Component && (object = (component2 = (Component)object).getContents()) instanceof TranslatableContents) {
                    TranslatableContents innerContents = (TranslatableContents)object;
                    contents = innerContents;
                }
                String id = contents.getKey();
                if (!ids.contains(id)) continue;
                int index = i + 1;
                EffectLinesHelper.getEffectDescriptionComponent(id).ifPresent(component -> {
                    List tooltipLines = Proxy.INSTANCE.splitTooltipLines(component);
                    for (Component tooltipLine : tooltipLines.reversed()) {
                        if (indentation > 0) {
                            tooltipLine = Component.literal((String)StringUtils.repeat((String)" ", (int)indentation)).append(tooltipLine);
                        }
                        lines.add(index, tooltipLine);
                    }
                });
            }
        }
    }

    private static List<MobEffectInstance> getMobEffects(ItemStack itemStack) {
        if (itemStack.has(DataComponents.SUSPICIOUS_STEW_EFFECTS)) {
            SuspiciousStewEffects suspiciousStewEffects = (SuspiciousStewEffects)itemStack.getOrDefault(DataComponents.SUSPICIOUS_STEW_EFFECTS, (Object)SuspiciousStewEffects.EMPTY);
            return Lists.transform((List)suspiciousStewEffects.effects(), SuspiciousStewEffects.Entry::createEffectInstance);
        }
        if (itemStack.has(DataComponents.FOOD)) {
            return Lists.transform((List)((FoodProperties)itemStack.get(DataComponents.FOOD)).effects(), FoodProperties.PossibleEffect::effect);
        }
        PotionContents potionContents = (PotionContents)itemStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        return Lists.newArrayList((Iterable)potionContents.getAllEffects());
    }
}

