/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.client.gui.screens.inventory;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.config.ClientConfig;
import fuzs.easymagic.config.ServerConfig;
import fuzs.easymagic.util.PlayerExperienceHelper;
import fuzs.easymagic.world.inventory.ModEnchantmentMenu;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import org.jetbrains.annotations.Nullable;

public class ModEnchantmentScreen
extends EnchantmentScreen {
    public static final String KEY_ONE_LAPIS_LAZULI = "container.enchant.lapis.one";
    public static final String KEY_MANY_LAPIS_LAZULI = "container.enchant.lapis.many";
    public static final String KEY_ONE_ENCHANTMENT_LEVEL = "container.enchant.level.one";
    public static final String KEY_MANY_ENCHANTMENT_LEVELS = "container.enchant.level.many";
    public static final String KEY_ONE_EXPERIENCE_POINT = "container.enchant.experience.one";
    public static final String KEY_MANY_EXPERIENCE_POINTS = "container.enchant.experience.many";
    public static final String KEY_REROLL = "container.enchant.reroll";
    private static final ResourceLocation ENCHANTING_TABLE_LOCATION = ResourceLocationHelper.withDefaultNamespace((String)"textures/gui/container/enchanting_table.png");
    private static final ResourceLocation ENCHANTING_TABLE_REROLL_LOCATION = EasyMagic.id("textures/gui/container/enchanting_table_reroll.png");
    private final List<List<EnchantmentInstance>> slotData = IntStream.range(0, 3).mapToObj(i -> Lists.newArrayList()).collect(Collectors.toList());

    public ModEnchantmentScreen(EnchantmentMenu enchantmentMenu, Inventory inventory, Component title) {
        super(enchantmentMenu, inventory, title);
    }

    protected void renderBg(GuiGraphics guiGraphics, float tickDelta, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, tickDelta, mouseX, mouseY);
        if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollEnchantments && !((ClientConfig)EasyMagic.CONFIG.get(ClientConfig.class)).keepEnchantmentScreenBook) {
            this.renderRerollButton(guiGraphics, tickDelta, mouseX, mouseY);
        }
        if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.blit(ENCHANTING_TABLE_LOCATION, this.leftPos + 4, this.topPos + 46, 14, 46, 18, 18);
            guiGraphics.blit(ENCHANTING_TABLE_LOCATION, this.leftPos + 22, this.topPos + 46, 34, 46, 18, 18);
            guiGraphics.blit(ENCHANTING_TABLE_REROLL_LOCATION, this.leftPos + 40, this.topPos + 46, 0, 81, 18, 18);
        }
    }

    protected void renderBook(GuiGraphics guiGraphics, int x, int y, float partialTick) {
        if (((ClientConfig)EasyMagic.CONFIG.get(ClientConfig.class)).keepEnchantmentScreenBook) {
            super.renderBook(guiGraphics, x, y, partialTick);
        }
    }

    private void renderRerollButton(GuiGraphics guiGraphics, float tickDelta, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int experienceCost = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost;
        int lapisCost = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost;
        boolean invalid = !this.minecraft.player.getAbilities().instabuild && (PlayerExperienceHelper.getTotalExperience((Player)this.minecraft.player) < experienceCost || this.getMenu().getRerollCatalystCount() < lapisCost);
        int buttonX = this.leftPos + (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst ? 12 : 14);
        int buttonY = this.topPos + 16;
        boolean hovered = this.isMouseOverReroll(mouseX, mouseY);
        boolean canUseReroll = this.getMenu().canUseReroll();
        guiGraphics.blit(ENCHANTING_TABLE_REROLL_LOCATION, buttonX, buttonY, 0, !canUseReroll || invalid ? 0 : (hovered ? 54 : 27), 38, 27);
        if (canUseReroll) {
            if (experienceCost == 0 && lapisCost == 0) {
                guiGraphics.blit(ENCHANTING_TABLE_REROLL_LOCATION, buttonX + 12, buttonY + 6, 64, invalid ? 0 : (hovered ? 30 : 15), 15, 15);
            } else {
                guiGraphics.blit(ENCHANTING_TABLE_REROLL_LOCATION, buttonX + 3, buttonY + 6, 64, invalid ? 0 : (hovered ? 30 : 15), 15, 15);
                if (experienceCost > 0 && lapisCost > 0) {
                    this.renderCostOrb(guiGraphics, buttonX + (experienceCost > 9 ? 17 : 20), buttonY + 13, 38, invalid ? 39 : 0, experienceCost, invalid ? ChatFormatting.RED : ChatFormatting.GREEN);
                    this.renderCostOrb(guiGraphics, buttonX + (lapisCost > 9 ? 17 : 20), buttonY + 1, 51, invalid ? 39 : 0, lapisCost, invalid ? ChatFormatting.RED : ChatFormatting.BLUE);
                } else if (experienceCost > 0) {
                    this.renderCostOrb(guiGraphics, buttonX + (experienceCost > 9 ? 17 : 20), buttonY + 7, 38, invalid ? 39 : 0, experienceCost, invalid ? ChatFormatting.RED : ChatFormatting.GREEN);
                } else if (lapisCost > 0) {
                    this.renderCostOrb(guiGraphics, buttonX + (lapisCost > 9 ? 17 : 20), buttonY + 7, 51, invalid ? 39 : 0, lapisCost, invalid ? ChatFormatting.RED : ChatFormatting.BLUE);
                }
            }
        }
    }

    private void renderCostOrb(GuiGraphics guiGraphics, int posX, int posY, int textureX, int textureY, int cost, ChatFormatting color) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(ENCHANTING_TABLE_REROLL_LOCATION, posX, posY, textureX, textureY + Math.min(2, cost / 5) * 13, 13, 13);
        this.renderReadableText(guiGraphics, posX + 8, posY + 3, String.valueOf(cost), color.getColor());
    }

    private void renderReadableText(GuiGraphics guiGraphics, int posX, int posY, String text, int color) {
        guiGraphics.drawString(this.font, text, posX - 1, posY, 0, false);
        guiGraphics.drawString(this.font, text, posX + 1, posY, 0, false);
        guiGraphics.drawString(this.font, text, posX, posY - 1, 0, false);
        guiGraphics.drawString(this.font, text, posX, posY + 1, 0, false);
        guiGraphics.drawString(this.font, text, posX, posY, color, false);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollEnchantments && this.isMouseOverReroll((int)mouseX, (int)mouseY) && ((EnchantmentMenu)this.menu).clickMenuButton((Player)this.minecraft.player, 4)) {
            this.minecraft.gameMode.handleInventoryButtonClick(((EnchantmentMenu)this.menu).containerId, 4);
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.ENCHANTMENT_TABLE_USE, (float)1.0f));
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int slot = this.getEnchantingSlot(mouseX, mouseY);
        if (slot != -1) {
            if (!this.slotData.get(slot).isEmpty()) {
                ArrayList tooltip = Lists.newArrayList();
                boolean hasValidEnchantment = this.gatherSlotEnchantmentsTooltip(this.slotData.get(slot), tooltip);
                this.gatherSlotCostsTooltip(slot, tooltip, hasValidEnchantment);
                guiGraphics.renderComponentTooltip(this.font, (List)tooltip, mouseX, mouseY);
            }
        } else if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollEnchantments && this.isMouseOverReroll(mouseX, mouseY) && this.getMenu().canUseReroll()) {
            ArrayList tooltip = Lists.newArrayList();
            this.gatherRerollTooltip(tooltip);
            guiGraphics.renderComponentTooltip(this.font, (List)tooltip, mouseX, mouseY);
        }
    }

    private boolean isMouseOverReroll(int mouseX, int mouseY) {
        int startX = this.leftPos + (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst ? 12 : 14);
        int startY = this.topPos + 16;
        return startX < mouseX && mouseX <= startX + 38 && startY < mouseY && mouseY <= startY + 27;
    }

    public boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        if (this.getSelectedSlot(mouseX, mouseY) != null) {
            return super.isHovering(x, y, width, height, mouseX, mouseY);
        }
        return false;
    }

    @Nullable
    private Slot getSelectedSlot(double mouseX, double mouseY) {
        for (int i = 0; i < ((EnchantmentMenu)this.menu).slots.size(); ++i) {
            Slot slot = (Slot)((EnchantmentMenu)this.menu).slots.get(i);
            if (!this.isSlotSelected(slot, mouseX, mouseY) || !slot.isActive()) continue;
            return slot;
        }
        return null;
    }

    private boolean isSlotSelected(Slot slotIn, double mouseX, double mouseY) {
        return super.isHovering(slotIn.x, slotIn.y, 16, 16, mouseX, mouseY);
    }

    private int getEnchantingSlot(int mouseX, int mouseY) {
        for (int j = 0; j < 3; ++j) {
            int levels = ((EnchantmentMenu)this.menu).costs[j];
            if (!super.isHovering(60, 14 + 19 * j, 108, 17, (double)mouseX, (double)mouseY) || levels <= 0) continue;
            return j;
        }
        return -1;
    }

    public void setSlotData(int slot, List<EnchantmentInstance> data) {
        this.slotData.set(slot, data);
    }

    private boolean gatherSlotEnchantmentsTooltip(List<EnchantmentInstance> slotData, List<Component> slotTooltip) {
        boolean hasValidEnchantment = slotData.isEmpty();
        for (EnchantmentInstance data : slotData) {
            MutableComponent component = Component.empty().append(Enchantment.getFullname((Holder)data.enchantment, (int)data.level)).withStyle(ChatFormatting.GRAY);
            if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).enchantmentHint == ServerConfig.EnchantmentHint.ALL) {
                slotTooltip.add((Component)component);
            } else {
                slotTooltip.add((Component)Component.translatable((String)"container.enchant.clue", (Object[])new Object[]{component}));
            }
            hasValidEnchantment = true;
        }
        return hasValidEnchantment;
    }

    private void gatherSlotCostsTooltip(int slot, List<Component> slotTooltip, boolean hasValidEnchantment) {
        ArrayList additionalTooltip = Lists.newArrayList();
        if (ModLoaderEnvironment.INSTANCE.getModLoader().isNeoForge() && !hasValidEnchantment) {
            additionalTooltip.add(Component.translatable((String)"neoforge.container.enchant.limitedEnchantability").withStyle(ChatFormatting.RED));
        } else if (ModLoaderEnvironment.INSTANCE.getModLoader().isForge() && !hasValidEnchantment) {
            additionalTooltip.add(Component.translatable((String)"forge.container.enchant.limitedEnchantability").withStyle(ChatFormatting.RED));
        } else if (!this.minecraft.player.getAbilities().instabuild) {
            int enchantLevels = ((EnchantmentMenu)this.menu).costs[slot];
            if (this.minecraft.player.experienceLevel < enchantLevels) {
                additionalTooltip.add(Component.translatable((String)"container.enchant.level.requirement", (Object[])new Object[]{enchantLevels}).withStyle(ChatFormatting.RED));
            } else {
                ModEnchantmentScreen.getEnchantingComponent(slot + 1, ((EnchantmentMenu)this.menu).getGoldCount(), KEY_ONE_LAPIS_LAZULI, KEY_MANY_LAPIS_LAZULI).ifPresent(additionalTooltip::add);
                ModEnchantmentScreen.getEnchantingComponent(slot + 1, this.minecraft.player.experienceLevel, KEY_ONE_ENCHANTMENT_LEVEL, KEY_MANY_ENCHANTMENT_LEVELS).ifPresent(additionalTooltip::add);
            }
        }
        if (!additionalTooltip.isEmpty()) {
            if (!slotTooltip.isEmpty()) {
                slotTooltip.add((Component)Component.empty());
            }
            slotTooltip.addAll(additionalTooltip);
        }
    }

    private void gatherRerollTooltip(List<Component> tooltip) {
        tooltip.add((Component)Component.translatable((String)KEY_REROLL).withStyle(ChatFormatting.GRAY));
        ArrayList additionalTooltip = Lists.newArrayList();
        if (!this.minecraft.player.getAbilities().instabuild) {
            int rerollCatalystCost = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost;
            if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst) {
                MutableComponent component = Component.literal((String)(rerollCatalystCost + " ")).append(Items.AMETHYST_SHARD.getDescription());
                ModEnchantmentScreen.getEnchantingComponent(rerollCatalystCost, this.getMenu().getRerollCatalystCount(), component).ifPresent(additionalTooltip::add);
            } else {
                ModEnchantmentScreen.getEnchantingComponent(rerollCatalystCost, this.getMenu().getRerollCatalystCount(), KEY_ONE_LAPIS_LAZULI, KEY_MANY_LAPIS_LAZULI).ifPresent(additionalTooltip::add);
            }
            String singleKey = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollingTakesEnchantmentLevels ? KEY_ONE_ENCHANTMENT_LEVEL : KEY_ONE_EXPERIENCE_POINT;
            String manyKey = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollingTakesEnchantmentLevels ? KEY_MANY_ENCHANTMENT_LEVELS : KEY_MANY_EXPERIENCE_POINTS;
            ModEnchantmentScreen.getEnchantingComponent(((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost, PlayerExperienceHelper.getTotalExperience((Player)this.minecraft.player), singleKey, manyKey).ifPresent(additionalTooltip::add);
        }
        if (!additionalTooltip.isEmpty()) {
            tooltip.add((Component)Component.empty());
            tooltip.addAll(additionalTooltip);
        }
    }

    private static Optional<Component> getEnchantingComponent(int requiredAmount, int currentAmount, String singleKey, String manyKey) {
        if (requiredAmount < 1) {
            return Optional.empty();
        }
        MutableComponent component = requiredAmount == 1 ? Component.translatable((String)singleKey) : Component.translatable((String)manyKey, (Object[])new Object[]{requiredAmount});
        return ModEnchantmentScreen.getEnchantingComponent(requiredAmount, currentAmount, component);
    }

    private static Optional<Component> getEnchantingComponent(int requiredAmount, int currentAmount, MutableComponent component) {
        if (requiredAmount < 1) {
            return Optional.empty();
        }
        return Optional.of(component.withStyle(currentAmount >= requiredAmount ? ChatFormatting.GRAY : ChatFormatting.RED));
    }

    public ModEnchantmentMenu getMenu() {
        return (ModEnchantmentMenu)super.getMenu();
    }
}

