/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.client.gui.components;

import com.google.common.collect.Lists;
import fuzs.easyanvils.client.gui.components.AdvancedEditBox;
import fuzs.easyanvils.util.ComponentDecomposer;
import fuzs.easyanvils.util.FormattedStringDecomposer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class FormattableEditBox
extends AdvancedEditBox {
    public FormattableEditBox(Font font, int x, int y, int width, int height, Component message) {
        this(font, x, y, width, height, null, message);
    }

    public FormattableEditBox(Font font, int x, int y, int width, int height, @Nullable EditBox editBox, Component message) {
        super(font, x, y, width, height, editBox, message);
        this.formatter = (formatterValue, position) -> {
            ArrayList list = Lists.newArrayList();
            FormattedStringDecomposer.LengthLimitedCharSink sink = new FormattedStringDecomposer.LengthLimitedCharSink(formatterValue.length(), (int)position);
            FormattedStringDecomposer.iterateFormatted(this.value, Style.EMPTY, (index, style, j) -> {
                if (sink.accept(index, style, j)) {
                    list.add(formattedCharSink -> formattedCharSink.accept(index, style, j));
                }
                return true;
            });
            return FormattedCharSequence.composite((List)list);
        };
    }

    public void setValue(String text) {
        if (this.filter.test(text)) {
            int aboveMaxLength = ComponentDecomposer.getStringLength(text) - this.maxLength;
            this.value = aboveMaxLength > 0 ? ComponentDecomposer.removeLast(text, aboveMaxLength) : text;
            this.moveCursorToEnd(false);
            this.setHighlightPos(this.cursorPos);
            this.onValueChange(text);
        }
    }

    public void insertText(String textToWrite) {
        String string2;
        String string;
        int j;
        int i = Math.min(this.cursorPos, this.highlightPos);
        String string3 = new StringBuilder(this.value).replace(i, j = Math.max(this.cursorPos, this.highlightPos), string = FormattedStringDecomposer.filterText(textToWrite)).toString();
        int stringLength = ComponentDecomposer.getStringLength(string3) - this.maxLength;
        if (stringLength > 0) {
            string = ComponentDecomposer.removeLast(textToWrite, stringLength);
        }
        if (this.filter.test(string2 = new StringBuilder(this.value).replace(i, j, string).toString())) {
            this.value = string2;
            int l = string.length();
            this.setCursorPosition(i + l);
            this.setHighlightPos(this.cursorPos);
            this.onValueChange(this.value);
        }
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (!this.canConsumeInput()) {
            return false;
        }
        if (FormattedStringDecomposer.isAllowedChatCharacter(codePoint)) {
            if (this.isEditable) {
                this.insertText(Character.toString(codePoint));
            }
            return true;
        }
        return false;
    }

    @Override
    public void onClick(double mouseX, double mouseY) {
        int i = Mth.floor((double)mouseX) - this.getX();
        if (this.bordered) {
            i -= 4;
        }
        String string = FormattedStringDecomposer.plainHeadByWidth(this.font, this.value, this.displayPos, this.getInnerWidth(), Style.EMPTY);
        this.moveCursorTo(FormattedStringDecomposer.plainHeadByWidth(this.font, string, 0, i, Style.EMPTY).length() + this.displayPos, Screen.hasShiftDown());
        long millis = Util.getMillis();
        boolean tripleClick = this.doubleClick;
        boolean bl = this.doubleClick = millis - this.lastClickTime < 250L;
        if (this.doubleClick) {
            if (tripleClick) {
                this.moveCursorToEnd(false);
                this.setHighlightPos(0);
            } else {
                this.doubleClickHighlightPos = this.getWordPosition(1, this.getCursorPosition(), false);
                this.moveCursorTo(this.doubleClickHighlightPos, false);
                this.doubleClickCursorPos = this.getWordPosition(-1, this.getCursorPosition(), false);
                this.moveCursorTo(this.doubleClickCursorPos, true);
            }
        }
        this.lastClickTime = millis;
    }

    @Override
    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        int i = Mth.floor((double)mouseX) - this.getX();
        if (this.bordered) {
            i -= 4;
        }
        String string = FormattedStringDecomposer.plainHeadByWidth(this.font, this.value, this.displayPos, this.getInnerWidth(), Style.EMPTY);
        int mousePosition = FormattedStringDecomposer.plainHeadByWidth(this.font, string, 0, i, Style.EMPTY).length() + this.displayPos;
        if (this.doubleClick) {
            if (this.clicked(mouseX, mouseY)) {
                int rightBoundary = this.getWordPosition(1, mousePosition, false);
                this.moveCursorTo(Math.max(this.doubleClickHighlightPos, rightBoundary), false);
                int leftBoundary = this.getWordPosition(-1, mousePosition, false);
                this.moveCursorTo(Math.min(this.doubleClickCursorPos, leftBoundary), true);
            } else {
                if (mousePosition > this.doubleClickHighlightPos) {
                    this.moveCursorToEnd(false);
                } else {
                    this.moveCursorTo(this.doubleClickHighlightPos, false);
                }
                if (mousePosition < this.doubleClickCursorPos) {
                    this.moveCursorToStart(true);
                } else {
                    this.moveCursorTo(this.doubleClickCursorPos, true);
                }
            }
        } else if (this.clicked(mouseX, mouseY)) {
            this.moveCursorTo(mousePosition, true);
        } else if (this.highlightPos < mousePosition) {
            this.moveCursorToEnd(true);
        } else {
            this.moveCursorToStart(true);
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.isVisible()) {
            if (this.isBordered()) {
                ResourceLocation resourceLocation = SPRITES.get(this.isActive(), this.isFocused());
                guiGraphics.blitSprite(resourceLocation, this.getX(), this.getY(), this.getWidth(), this.getHeight());
            }
            int i = this.isEditable ? this.textColor : this.textColorUneditable;
            int j = this.cursorPos - this.displayPos;
            String string = FormattedStringDecomposer.plainHeadByWidth(this.font, this.value, this.displayPos, this.getInnerWidth(), Style.EMPTY);
            boolean bl = j >= 0 && j <= string.length();
            boolean bl2 = this.isFocused() && (Util.getMillis() - this.focusedTime) / 300L % 2L == 0L && bl;
            int l = this.bordered ? this.getX() + 4 : this.getX();
            int m = this.bordered ? this.getY() + (this.height - 8) / 2 : this.getY();
            int n = l;
            int k = Mth.clamp((int)(this.highlightPos - this.displayPos), (int)0, (int)string.length());
            if (k > string.length()) {
                k = string.length();
            }
            if (!string.isEmpty()) {
                String string2 = bl ? string.substring(0, j) : string;
                n = guiGraphics.drawString(this.font, (FormattedCharSequence)this.formatter.apply(string2, this.displayPos), l, m, i);
            }
            boolean bl3 = this.cursorPos < this.value.length() || ComponentDecomposer.getStringLength(this.value) >= this.getMaxLength();
            int o = n;
            if (!bl) {
                o = j > 0 ? l + this.width : l;
            } else if (!string.isEmpty()) {
                o = n - 1;
                --n;
            }
            if (!string.isEmpty() && bl && j < string.length()) {
                guiGraphics.drawString(this.font, (FormattedCharSequence)this.formatter.apply(string.substring(j), this.cursorPos), n, m, i);
            }
            if (this.hint != null && string.isEmpty() && !this.isFocused()) {
                guiGraphics.drawString(this.font, this.hint, m, l, i);
            }
            if (!bl3 && this.suggestion != null) {
                guiGraphics.drawString(this.font, this.suggestion, o - 1, m, -8355712);
            }
            if (bl2 && k == j) {
                if (!string.isEmpty()) {
                    guiGraphics.fill(RenderType.guiOverlay(), o, m - 1, o + 1, m + 1 + 9, -3092272);
                } else {
                    guiGraphics.drawString(this.font, "_", o, m, i);
                }
            }
            if (k != j) {
                int p = l + FormattedStringDecomposer.stringWidth(this.font, this.value.substring(0, this.highlightPos), this.displayPos);
                this.renderHighlight(guiGraphics, o, m - 1, p - 1, m + 1 + 9);
            }
        }
    }

    protected void scrollTo(int position) {
        int i = this.value.length();
        if (this.displayPos > i) {
            this.displayPos = i;
        }
        int j = this.getInnerWidth();
        String string = FormattedStringDecomposer.plainHeadByWidth(this.font, this.value, this.displayPos, j, Style.EMPTY);
        int k = string.length() + this.displayPos;
        if (position == this.displayPos) {
            this.displayPos -= FormattedStringDecomposer.plainTailByWidth(this.font, this.value, j, Style.EMPTY).length();
        }
        if (position > k) {
            this.displayPos += position - k;
        } else if (position <= this.displayPos) {
            this.displayPos -= this.displayPos - position;
        }
        this.displayPos = Mth.clamp((int)this.displayPos, (int)0, (int)i);
    }

    public int getScreenX(int charNum) {
        return charNum > this.value.length() ? this.getX() : this.getX() + FormattedStringDecomposer.stringWidth(this.font, this.value.substring(0, charNum), 0);
    }
}

