/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.PlacementConfiguration;
import xiroc.dungeoncrawl.dungeon.model.ModelSelector;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.init.ModStructurePieceTypes;

public class DungeonCorridor
extends DungeonPiece {
    public DungeonCorridor() {
        super((StructurePieceType)ModStructurePieceTypes.CORRIDOR.get());
    }

    public DungeonCorridor(CompoundTag p_i51343_2_) {
        super((StructurePieceType)ModStructurePieceTypes.CORRIDOR.get(), p_i51343_2_);
    }

    @Override
    public void setupModel(DungeonBuilder builder, ModelSelector modelSelector, List<DungeonPiece> pieces, RandomSource rand) {
        this.model = this.connectedSides == 2 && this.isStraight() ? modelSelector.corridors.roll(rand) : modelSelector.corridorLinkers.roll(rand);
    }

    public void postProcess(WorldGenLevel worldIn, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, RandomSource randomIn, BoundingBox structureBoundingBoxIn, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
        if (this.model == null) {
            DungeonCrawl.LOGGER.warn("Missing model for {}", (Object)this);
            return;
        }
        Vec3i offset = this.model.getOffset(this.rotation);
        BlockPos pos = new BlockPos(this.x, this.y, this.z).offset(offset);
        this.buildModel(this.model, (LevelAccessor)worldIn, structureBoundingBoxIn, pos, randomIn, PlacementConfiguration.CORRIDOR, this.theme, this.secondaryTheme, this.stage, this.rotation, false, false);
        if (this.connectedSides != 2 || !this.isStraight()) {
            this.entrances((LevelAccessor)worldIn, structureBoundingBoxIn, this.model, randomIn);
        }
        this.placeFeatures((LevelAccessor)worldIn, structureBoundingBoxIn, this.theme, this.secondaryTheme, randomIn, this.stage);
        this.decorate((LevelAccessor)worldIn, pos, this.theme, randomIn, structureBoundingBoxIn, this.boundingBox, this.model);
    }

    @Override
    protected boolean hasPillarAt(BlockPos pos) {
        if (this.rotation == Rotation.NONE || this.rotation == Rotation.CLOCKWISE_180) {
            return pos.getX() % 6 == 0 && pos.getZ() % 3 == 0;
        }
        return pos.getX() % 3 == 0 && pos.getZ() % 6 == 0;
    }

    @Override
    public void createBoundingBox() {
        if (this.model != null) {
            this.boundingBox = this.model.createBoundingBoxWithOffset(this.x, this.y, this.z, this.rotation);
        }
    }

    @Override
    public int getDungeonPieceType() {
        return 0;
    }

    public boolean isStraight() {
        return this.sides[0] && this.sides[2] || this.sides[1] && this.sides[3];
    }
}

