/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.util;

import java.util.function.Function;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;

public class TargetingFunctions {
    public static boolean attackTargets(Entity attacker, Function<Entity, Boolean> action, Entity ... entities) {
        boolean valid = false;
        for (Entity entity : entities) {
            if (!TargetingFunctions.isValidTarget(attacker, entity) || !action.apply(entity).booleanValue()) continue;
            valid = true;
        }
        return valid;
    }

    public static boolean attackTargets(ServerLevel level, EntityPredicate predicate, Entity attacker, Function<Entity, Boolean> action, Entity ... entities) {
        boolean valid = false;
        for (Entity entity : entities) {
            if (!TargetingFunctions.isValidTarget(attacker, entity) || !predicate.matches(level, entity.position(), entity) || !action.apply(entity).booleanValue()) continue;
            valid = true;
        }
        return valid;
    }

    public static boolean isValidTarget(Entity attacker, Entity target) {
        if (target == null || attacker == null) {
            return false;
        }
        if (target == attacker) {
            return false;
        }
        if (target instanceof FakePlayer) {
            return false;
        }
        if (attacker instanceof Player) {
            Player targetPlayer;
            Player attackerPlayer = (Player)attacker;
            if (target instanceof Player && !attackerPlayer.canHarmPlayer(targetPlayer = (Player)target)) {
                return false;
            }
        }
        if (attacker.getTeam() != null && target.getTeam() != null && attacker.getTeam().getPlayers().contains(target.getScoreboardName()) && !target.getTeam().isAllowFriendlyFire()) {
            return false;
        }
        LivingEntity owner = null;
        if (target instanceof TamableAnimal) {
            owner = ((TamableAnimal)target).getOwner();
        }
        if (owner == attacker) {
            return false;
        }
        return owner == null || TargetingFunctions.isValidTarget(attacker, (Entity)owner);
    }

    public static AABB boxForRange(Vec3 v, double range) {
        return TargetingFunctions.boxForRange(v, range, range, range);
    }

    public static AABB boxForRange(Vec3 v, double rangeX, double rangeY, double rangeZ) {
        return new AABB(v.x - rangeX, v.y - rangeY, v.z - rangeZ, v.x + rangeX, v.y + rangeY, v.z + rangeZ);
    }

    public static Vec3 fromEntityCenter(Entity e) {
        return new Vec3(e.getX(), e.getY() + (double)(e.getBbHeight() / 2.0f), e.getZ());
    }
}

