/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.util;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.Nullable;

public class ResourceHelper {
    private static final RandomSource RANDOM = RandomSource.create();

    public static <T> Optional<Holder.Reference<T>> get(@Nullable HolderLookup.Provider provider, ResourceKey<T> key) {
        return ResourceHelper.getRegistry(provider, key.registryKey()).get(key);
    }

    public static <T> List<Holder.Reference<T>> all(@Nullable HolderLookup.Provider provider, ResourceKey<Registry<T>> key) {
        return ResourceHelper.getRegistry(provider, key).listElements().toList();
    }

    public static <T> Holder<T> random(@Nullable HolderLookup.Provider provider, ResourceKey<Registry<T>> key) {
        List elements = ResourceHelper.getRegistry(provider, key).listElements().toList();
        return (Holder)elements.get(RANDOM.nextInt(elements.size()));
    }

    public static <T> List<ResourceKey<T>> keys(@Nullable HolderLookup.Provider provider, ResourceKey<Registry<T>> key) {
        return ResourceHelper.getRegistry(provider, key).listElementIds().toList();
    }

    @Nullable
    public static <T> ResourceKey<T> decodeKey(@Nullable HolderLookup.Provider provider, ResourceKey<Registry<T>> registryKey, CompoundTag tag, String key) {
        HolderLookup.Provider actualProvider;
        if (!tag.contains(key)) {
            return null;
        }
        Object object = actualProvider = provider != null ? provider : DragonSurvival.PROXY.getAccess();
        if (actualProvider == null) {
            DragonSurvival.LOGGER.error("Context was not available to deserialize the value of [{}] from the tag [{}]", (Object)key, (Object)tag);
            return null;
        }
        ResourceKey resource = (ResourceKey)ResourceKey.codec(registryKey).decode((DynamicOps)actualProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.get(key)).mapOrElse(Pair::getFirst, error -> {
            DragonSurvival.LOGGER.error(error.message());
            return null;
        });
        if (resource != null && actualProvider.holder(resource).isEmpty()) {
            return null;
        }
        return resource;
    }

    @Nullable
    public static <T> Tag encodeKey(@Nullable HolderLookup.Provider provider, ResourceKey<T> key) {
        HolderLookup.Provider actualProvider;
        if (key == null) {
            return null;
        }
        Object object = actualProvider = provider != null ? provider : DragonSurvival.PROXY.getAccess();
        if (actualProvider == null) {
            DragonSurvival.LOGGER.error("Context was not available to serialize the value [{}]", key);
            return null;
        }
        return (Tag)ResourceKey.codec((ResourceKey)key.registryKey()).encodeStart((DynamicOps)actualProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), key).mapOrElse(Function.identity(), error -> {
            DragonSurvival.LOGGER.error(error.message());
            return null;
        });
    }

    private static <T> HolderLookup.RegistryLookup<T> getRegistry(@Nullable HolderLookup.Provider provider, ResourceKey<Registry<T>> key) {
        HolderLookup.RegistryLookup registry = provider == null ? CommonHooks.resolveLookup(key) : provider.lookupOrThrow(key);
        return registry;
    }
}

