/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.util;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.ColorRGBA;
import net.minecraft.util.FastColor;

public class DSColors {
    public static final int NONE = -1;
    public static final int BLACK = 0;
    public static final int WHITE = 0xFFFFFF;
    public static final int BLUE = 0x5555FF;
    public static final int GRAY = 0xAAAAAA;
    public static final int GOLD = 0xFFAA00;
    public static final int DARK_RED = 0xAA0000;
    public static final int GREEN = 5736495;
    public static final int RED = 15937595;
    public static final int DARK_GRAY = 0x262626;
    public static final int LIGHT_PURPLE = 10126490;
    public static final int DARK_PURPLE = 0x594459;
    public static final int PASSIVE_BACKGROUND = 8360238;
    public static final int ACTIVE_BACKGROUND = 13141535;
    public static final int CAVE_TOP = 16742022;
    public static final int CAVE_BOTTOM = 9126474;
    public static final int FOREST_TOP = 65428;
    public static final int FOREST_BOTTOM = 295506;
    public static final int SEA_TOP = 6146559;
    public static final int SEA_BOTTOM = 3239312;

    public static MutableComponent dynamicValue(Object value) {
        return DSColors.withColor(value, 0x5555FF);
    }

    public static MutableComponent withColor(Object value, int color) {
        if (value instanceof MutableComponent) {
            MutableComponent mutable = (MutableComponent)value;
            return mutable.withColor(color);
        }
        return Component.literal((String)String.valueOf(value)).withColor(color);
    }

    public static int withoutAlpha(int rgba) {
        return rgba >>> 8;
    }

    public static int withAlpha(int rgb, float alpha) {
        return FastColor.ARGB32.color((int)((int)(255.0f * alpha)), (int)rgb);
    }

    public static int toARGB(TextColor color) {
        return FastColor.ARGB32.color((int)255, (int)color.getValue());
    }

    public static int toARGB(ColorRGBA color) {
        int rgba = color.rgba();
        int red = rgba >> 24 & 0xFF;
        int green = rgba >> 16 & 0xFF;
        int blue = rgba >> 8 & 0xFF;
        int alpha = rgba & 0xFF;
        return FastColor.ARGB32.color((int)alpha, (int)red, (int)green, (int)blue);
    }

    public record RGB(float red, float green, float blue) {
        public static RGB of(int rgb) {
            float red = rgb >> 16 & 0xFF;
            float green = rgb >> 8 & 0xFF;
            float blue = rgb & 0xFF;
            return new RGB(red / 255.0f, green / 255.0f, blue / 255.0f);
        }
    }
}

