/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.server.tileentity;

import by.dragonsurvivalteam.dragonsurvival.common.blocks.PrimordialAnchorBlock;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.registry.DSBlockEntities;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class PrimordialAnchorBlockEntity
extends BlockEntity {
    @Translation(key="anchor_has_bloody_state", type=Translation.Type.CONFIGURATION, comments={"If enabled, the primordial anchor will become unusuable as long as the ender dragon is dead."})
    @ConfigOption(side=ConfigSide.SERVER, category={"primordial_anchor"}, key="anchor_has_bloody_state")
    public static Boolean anchorHasBloodyState = true;

    public PrimordialAnchorBlockEntity(BlockPos position, BlockState state) {
        super((BlockEntityType)DSBlockEntities.PRIMORDIAL_ANCHOR.get(), position, state);
    }

    public static void serverTick(Level level, BlockPos position, BlockState state, PrimordialAnchorBlockEntity anchor) {
        if (ServerLifecycleHooks.getCurrentServer().getWorldData().endDragonFightData().dragonKilled() && anchorHasBloodyState.booleanValue()) {
            level.setBlockAndUpdate(position, (BlockState)state.setValue((Property)PrimordialAnchorBlock.BLOODY, (Comparable)Boolean.valueOf(true)));
        } else {
            level.setBlockAndUpdate(position, (BlockState)state.setValue((Property)PrimordialAnchorBlock.BLOODY, (Comparable)Boolean.valueOf(false)));
        }
    }
}

