/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.server.handlers;

import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncVisualEffectAdded;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncVisualEffectRemoval;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEffects;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber
public class VisualEffectSync {
    private static final List<Holder<MobEffect>> VISUAL_EFFECTS = List.of(DSEffects.DRAIN, DSEffects.CHARGED, DSEffects.BURN, DSEffects.BLOOD_SIPHON, DSEffects.REGENERATION_DELAY, DSEffects.TRAPPED, DSEffects.HUNTER);

    @SubscribeEvent
    public static void handleEffectAdded(MobEffectEvent.Added event) {
        LivingEntity entity = event.getEntity();
        if (entity.level().isClientSide()) {
            return;
        }
        MobEffectInstance instance = event.getEffectInstance();
        if (!VISUAL_EFFECTS.contains(instance.getEffect())) {
            return;
        }
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new SyncVisualEffectAdded(entity.getId(), instance), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @SubscribeEvent
    public static void handleEffectRemoved(MobEffectEvent.Remove event) {
        VisualEffectSync.handleEffectRemoval(event.getEffectInstance(), event.getEntity());
    }

    @SubscribeEvent
    public static void handleEffectExpired(MobEffectEvent.Expired event) {
        VisualEffectSync.handleEffectRemoval(event.getEffectInstance(), event.getEntity());
    }

    private static void handleEffectRemoval(MobEffectInstance instance, LivingEntity entity) {
        if (instance == null || entity.level().isClientSide()) {
            return;
        }
        if (!VISUAL_EFFECTS.contains(instance.getEffect())) {
            return;
        }
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new SyncVisualEffectRemoval(entity.getId(), (Holder<MobEffect>)instance.getEffect()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

