/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.server.handlers;

import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.EntityStruckByLightningEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

@EventBusSubscriber
public class LightningHandler
implements INBTSerializable<CompoundTag> {
    public boolean ignoresItemsAndExperience;
    public boolean spawnsFire;
    public boolean canHurtSelf;

    public @UnknownNullability CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("ignores_items_and_experience", this.ignoresItemsAndExperience);
        tag.putBoolean("spawns_fire", this.spawnsFire);
        tag.putBoolean("can_hurt_self", this.canHurtSelf);
        return tag;
    }

    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, CompoundTag nbt) {
        this.ignoresItemsAndExperience = nbt.getBoolean("ignores_items_and_experience");
        this.spawnsFire = nbt.getBoolean("spawns_fire");
        this.canHurtSelf = nbt.getBoolean("can_hurt_self");
    }

    public static LightningHandler fromData(Data data) {
        LightningHandler handler = new LightningHandler();
        handler.ignoresItemsAndExperience = data.ignoresItemsAndExperience;
        handler.spawnsFire = data.spawnsFire;
        handler.canHurtSelf = data.canHurtSelf;
        return handler;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleLightningBolt(EntityStruckByLightningEvent event) {
        LightningBolt bolt = event.getLightning();
        Entity target = event.getEntity();
        LightningHandler handler = (LightningHandler)bolt.getData(DSDataAttachments.LIGHTNING_BOLT);
        if (handler.ignoresItemsAndExperience && (target instanceof ItemEntity || target instanceof ExperienceOrb)) {
            event.setCanceled(true);
        }
        if (!handler.canHurtSelf && target == bolt.getCause()) {
            event.setCanceled(true);
        }
    }

    public record Data(boolean ignoresItemsAndExperience, boolean spawnsFire, boolean canHurtSelf) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("ignores_items_and_experience").forGetter(Data::ignoresItemsAndExperience), (App)Codec.BOOL.fieldOf("spawns_fire").forGetter(Data::spawnsFire), (App)Codec.BOOL.fieldOf("can_hurt_self").forGetter(Data::canHurtSelf)).apply((Applicative)instance, Data::new));
    }
}

