/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.server.handlers;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.MiscCodecs;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.registry.DSAttributes;
import by.dragonsurvivalteam.dragonsurvival.registry.DSDamageTypes;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import by.dragonsurvivalteam.dragonsurvival.util.BlockPosHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class DragonDestructionHandler {
    private static int crushTickCounter;
    private static boolean isBreakingMultipleBlocks;

    private static void checkAndDestroyCollidingBlocks(DragonStateHandler data, PlayerTickEvent event, AABB boundingBox) {
        MiscCodecs.DestructionData destructionData = ((DragonStage)data.stage().value()).destructionData().orElse(null);
        if (destructionData == null || !destructionData.isBlockDestructionAllowed(data.getGrowth())) {
            return;
        }
        BlockPosHelper.betweenClosedCeil(boundingBox).forEach(position -> {
            if (!destructionData.blockPredicate().test((Object)((ServerLevel)event.getEntity().level()), position)) {
                return;
            }
            if (event.getEntity().getRandom().nextDouble() > ServerConfig.blockDestructionRemoval) {
                event.getEntity().level().destroyBlock(position, false);
            } else {
                event.getEntity().level().removeBlock(position, false);
            }
        });
    }

    @SubscribeEvent
    public static void destroyBlocksInRadius(BlockEvent.BreakEvent event) {
        ServerPlayer player;
        if (isBreakingMultipleBlocks) {
            return;
        }
        Player player2 = event.getPlayer();
        if (!(player2 instanceof ServerPlayer) || (player = (ServerPlayer)player2).isCrouching()) {
            return;
        }
        int radius = (int)event.getPlayer().getAttributeValue(DSAttributes.BLOCK_BREAK_RADIUS);
        if (radius < 1) {
            return;
        }
        DragonStateHandler handler = DragonStateProvider.getData((Player)player);
        if (handler.multiMining == DragonStateHandler.MultiMining.DISABLED) {
            return;
        }
        event.setCanceled(true);
        isBreakingMultipleBlocks = true;
        float centerSpeed = event.getState().getDestroySpeed((BlockGetter)event.getLevel(), event.getPos());
        BlockPos.betweenClosedStream((AABB)AABB.ofSize((Vec3)event.getPos().getCenter(), (double)radius, (double)radius, (double)radius)).forEach(position -> {
            float speed = event.getLevel().getBlockState(position).getDestroySpeed((BlockGetter)event.getLevel(), position);
            if (speed != -1.0f && speed <= centerSpeed) {
                player.gameMode.destroyBlock(position);
            }
        });
        isBreakingMultipleBlocks = false;
    }

    @SubscribeEvent
    public static void checkAndDestroyCollidingBlocksAndCrushedEntities(PlayerTickEvent.Post event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (!(player2 instanceof ServerPlayer) || (player = (ServerPlayer)player2).isCrouching()) {
            return;
        }
        DragonStateHandler data = DragonStateProvider.getData((Player)player);
        if (!data.isDragon() || data.largeDragonDestruction == DragonStateHandler.LargeDragonDestruction.DISABLED) {
            return;
        }
        MiscCodecs.DestructionData destructionData = ((DragonStage)data.stage().value()).destructionData().orElse(null);
        if (destructionData == null || !destructionData.isDestructionAllowed(data.getGrowth())) {
            return;
        }
        Vec2 horizontalDeltaMovement = new Vec2((float)player.getDeltaMovement().x, (float)player.getDeltaMovement().z);
        if (horizontalDeltaMovement.length() < 0.05f && Math.abs(player.getDeltaMovement().y) < 0.25) {
            return;
        }
        AABB boundingBox = player.getBoundingBox();
        AABB blockCollisionBoundingBox = boundingBox.inflate(1.5);
        DragonDestructionHandler.checkAndDestroyCollidingBlocks(data, (PlayerTickEvent)event, blockCollisionBoundingBox);
        DragonDestructionHandler.checkAndDamageCrushedEntities(data, player, blockCollisionBoundingBox);
    }

    private static void checkAndDamageCrushedEntities(DragonStateHandler data, ServerPlayer player, AABB boundingBox) {
        MiscCodecs.DestructionData destructionData = ((DragonStage)data.stage().value()).destructionData().orElse(null);
        if (destructionData == null || !destructionData.isCrushingAllowed(data.getGrowth())) {
            return;
        }
        if (--crushTickCounter > 0) {
            return;
        }
        AABB feetBoundingBox = new AABB(boundingBox.minX, boundingBox.minY, boundingBox.minZ, boundingBox.maxX, boundingBox.maxY - (boundingBox.maxY - boundingBox.minY) / 3.0, boundingBox.maxZ);
        for (LivingEntity entity : player.level().getNearbyEntities(LivingEntity.class, TargetingConditions.DEFAULT, (LivingEntity)player, feetBoundingBox)) {
            if (entity.getBoundingBox().getSize() > boundingBox.getSize() * ServerConfig.crushingSizeRatio || !destructionData.entityPredicate().matches(player, (Entity)entity)) continue;
            entity.hurt(new DamageSource(DSDamageTypes.get(player.level(), DSDamageTypes.CRUSHED), (Entity)player), (float)(data.getGrowth() * destructionData.crushingDamageScalar()));
            crushTickCounter = ServerConfig.crushingTickDelay;
        }
    }
}

