/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.server.containers.slots;

import by.dragonsurvivalteam.dragonsurvival.registry.attachments.ClawInventoryData;
import by.dragonsurvivalteam.dragonsurvival.server.containers.DragonContainer;
import by.dragonsurvivalteam.dragonsurvival.util.ToolUtils;
import com.mojang.datafixers.util.Pair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClawToolSlot
extends Slot {
    private final DragonContainer dragonContainer;
    private final ClawInventoryData.Slot slot;

    public ClawToolSlot(DragonContainer dragonContainer, Container container, int index, int x, int y, ClawInventoryData.Slot slot) {
        super(container, index, x, y);
        this.dragonContainer = dragonContainer;
        this.slot = slot;
    }

    public boolean mayPlace(@NotNull ItemStack itemStack) {
        return switch (this.slot) {
            default -> throw new MatchException(null, null);
            case ClawInventoryData.Slot.SWORD -> ToolUtils.isWeapon(itemStack);
            case ClawInventoryData.Slot.PICKAXE -> ToolUtils.isPickaxe(itemStack);
            case ClawInventoryData.Slot.AXE -> ToolUtils.isAxe(itemStack);
            case ClawInventoryData.Slot.SHOVEL -> ToolUtils.isShovel(itemStack);
        };
    }

    public void set(@NotNull ItemStack itemStack) {
        super.set(itemStack);
        ClawInventoryData.getData(this.dragonContainer.player).sync(this.dragonContainer.player);
    }

    @Nullable
    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
        return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)this.slot.getEmptyTexture());
    }

    @NotNull
    public ItemStack remove(int amount) {
        ItemStack stack = super.remove(amount);
        ClawInventoryData.getData(this.dragonContainer.player).sync(this.dragonContainer.player);
        return stack;
    }

    public boolean isActive() {
        return this.dragonContainer.menuStatus == 1;
    }
}

