/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.server.containers;

import by.dragonsurvivalteam.dragonsurvival.registry.DSContainers;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.ClawInventoryData;
import by.dragonsurvivalteam.dragonsurvival.server.containers.slots.ClawToolSlot;
import by.dragonsurvivalteam.dragonsurvival.util.ToolUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ArmorSlot;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;

public class DragonContainer
extends AbstractContainerMenu {
    public final CraftingContainer craftMatrix = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
    public final ResultContainer craftResult = new ResultContainer();
    public final Player player;
    public final List<Slot> craftingSlots = new ArrayList<Slot>();
    public final List<Slot> inventorySlots = new ArrayList<Slot>();
    public final Inventory playerInventory;
    public int menuStatus;
    private static final EquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private static final ResourceLocation[] ARMOR_SLOT_TEXTURES = new ResourceLocation[]{InventoryMenu.EMPTY_ARMOR_SLOT_HELMET, InventoryMenu.EMPTY_ARMOR_SLOT_CHESTPLATE, InventoryMenu.EMPTY_ARMOR_SLOT_LEGGINGS, InventoryMenu.EMPTY_ARMOR_SLOT_BOOTS};
    private final int craftingResultIndex;
    protected final ContainerData dataStatus = new ContainerData(){

        public int get(int index) {
            if (index == 0) {
                return DragonContainer.this.menuStatus;
            }
            return 0;
        }

        public void set(int index, int value) {
            if (index == 0) {
                DragonContainer.this.menuStatus = value;
            }
        }

        public int getCount() {
            return 1;
        }
    };

    public DragonContainer(int id, Inventory inventory) {
        super((MenuType)DSContainers.DRAGON_CONTAINER.get(), id);
        int i;
        this.player = inventory.player;
        this.playerInventory = inventory;
        this.addDataSlots(this.dataStatus);
        for (i = 0; i < 4; ++i) {
            this.addSlot((Slot)new ArmorSlot((Container)inventory, (LivingEntity)this.player, VALID_EQUIPMENT_SLOTS[i], 39 - i, 8, 8 + i * 18, ARMOR_SLOT_TEXTURES[i]));
        }
        for (int column = 0; column < 3; ++column) {
            for (int row = 0; row < 9; ++row) {
                Slot s = new Slot((Container)inventory, row + column * 9 + 9, 8 + row * 18, 84 + column * 18);
                this.addSlot(s);
                this.inventorySlots.add(s);
            }
        }
        for (i = 0; i < 9; ++i) {
            Slot s = new Slot((Container)inventory, i, 8 + i * 18, 142);
            this.addSlot(s);
            this.inventorySlots.add(s);
        }
        ClawInventoryData clawInventory = ClawInventoryData.getData(this.player);
        for (int slot = 0; slot < ClawInventoryData.Slot.size(); ++slot) {
            ClawToolSlot clawToolSlot = new ClawToolSlot(this, (Container)clawInventory.getContainer(), slot, -26, 46 + slot * 18, ClawInventoryData.Slot.values()[slot]);
            this.addSlot(clawToolSlot);
        }
        this.addSlot(new Slot((Container)inventory, 40, 178, 142));
        this.addSlot((Slot)new ResultSlot(inventory.player, this.craftMatrix, (Container)this.craftResult, 0, 178, 44));
        this.craftingResultIndex = this.slots.size() - 1;
        for (int row = 0; row < this.craftMatrix.getWidth(); ++row) {
            for (int column = 0; column < this.craftMatrix.getHeight(); ++column) {
                Slot s = new Slot((Container)this.craftMatrix, column + row * 3, 116 + column * 18, 26 + row * 18);
                this.addSlot(s);
                this.craftingSlots.add(s);
            }
        }
        this.update();
    }

    public void update() {
        this.menuStatus = ClawInventoryData.getData(this.player).isMenuOpen() ? 1 : 0;
        this.broadcastChanges();
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            int i;
            ItemStack slotItemStack = slot.getItem();
            itemStack = slotItemStack.copy();
            EquipmentSlot equipmentSlot = player.getEquipmentSlotForItem(itemStack);
            if (index == this.craftingResultIndex) {
                if (this.menuStatus == 1 ? !this.moveItemStackTo(slotItemStack, 4, 44, true) : !this.moveItemStackTo(slotItemStack, 4, 40, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotItemStack, itemStack);
            } else if (equipmentSlot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR && !((Slot)this.slots.get(3 - equipmentSlot.getIndex())).hasItem() ? !this.moveItemStackTo(slotItemStack, i = 3 - equipmentSlot.getIndex(), i + 1, false) : (index < 4 ? !this.moveItemStackTo(slotItemStack, 4, 40, false) : (this.menuStatus == 1 && !((Slot)this.slots.get(42)).hasItem() && ToolUtils.isAxe(slotItemStack) ? !this.moveItemStackTo(slotItemStack, 42, 43, false) : (this.menuStatus == 1 && !((Slot)this.slots.get(40)).hasItem() && ToolUtils.isWeapon(slotItemStack) ? !this.moveItemStackTo(slotItemStack, 40, 41, false) : (this.menuStatus == 1 && !((Slot)this.slots.get(41)).hasItem() && ToolUtils.isPickaxe(slotItemStack) ? !this.moveItemStackTo(slotItemStack, 41, 42, false) : (this.menuStatus == 1 && !((Slot)this.slots.get(43)).hasItem() && ToolUtils.isShovel(slotItemStack) ? !this.moveItemStackTo(slotItemStack, 43, 44, false) : (equipmentSlot == EquipmentSlot.OFFHAND && !((Slot)this.slots.get(44)).hasItem() ? !this.moveItemStackTo(slotItemStack, 44, 45, false) : (index < 31 ? !this.moveItemStackTo(slotItemStack, 31, 40, false) : (index < 40 ? !this.moveItemStackTo(slotItemStack, 4, 31, false) : !this.moveItemStackTo(slotItemStack, 4, 31, false)))))))))) {
                return ItemStack.EMPTY;
            }
            if (slotItemStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY, itemStack);
            } else {
                slot.setChanged();
            }
            if (slotItemStack.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotItemStack);
            if (index == 0) {
                player.drop(slotItemStack, false);
            }
        }
        return itemStack;
    }

    public boolean canTakeItemForPickAll(@Nonnull ItemStack itemStack, Slot slot) {
        return slot.container != this.craftResult && super.canTakeItemForPickAll(itemStack, slot);
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        this.clearContainer(player, (Container)this.craftMatrix);
    }

    public void slotsChanged(@NotNull Container inventory) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack itemStack = ItemStack.EMPTY;
            Optional recipeOptional = serverPlayer.serverLevel().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)this.craftMatrix.asCraftInput(), serverPlayer.level());
            if (recipeOptional.isPresent()) {
                RecipeHolder recipe = (RecipeHolder)recipeOptional.get();
                if (this.craftResult.setRecipeUsed(this.player.level(), serverPlayer, recipe)) {
                    itemStack = ((CraftingRecipe)recipe.value()).assemble((RecipeInput)this.craftMatrix.asCraftInput(), (HolderLookup.Provider)serverPlayer.level().registryAccess());
                }
            }
            this.craftResult.setItem(45, itemStack);
            this.setRemoteSlot(45, itemStack);
            serverPlayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 45, itemStack));
        }
    }

    public boolean stillValid(@NotNull Player ignored) {
        return true;
    }
}

