/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.server;

import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.AmbusherEntity;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.ModifyCustomSpawnersEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
public class AmbusherSpawner
implements CustomSpawner {
    private int nextTick;

    public int tick(@NotNull ServerLevel level, boolean spawnEnemies, boolean spawnFriendlies) {
        if (!spawnEnemies || !level.getGameRules().getBoolean(GameRules.RULE_DO_PATROL_SPAWNING)) {
            return 0;
        }
        --this.nextTick;
        if (this.nextTick > 0) {
            return 0;
        }
        this.nextTick = this.nextTick + AmbusherEntity.SPAWN_FREQUENCY + level.getRandom().nextInt(AmbusherEntity.SPAWN_FREQUENCY / 10);
        if (!level.isDay() || level.getRandom().nextDouble() > AmbusherEntity.SPAWN_CHANCE) {
            return 0;
        }
        if (level.players().isEmpty()) {
            return 0;
        }
        Player player = (Player)level.players().get(level.getRandom().nextInt(level.players().size()));
        if (player.isCreative() || player.isSpectator()) {
            return 0;
        }
        int x = (24 + level.getRandom().nextInt(24)) * (level.getRandom().nextBoolean() ? -1 : 1);
        int z = (24 + level.getRandom().nextInt(24)) * (level.getRandom().nextBoolean() ? -1 : 1);
        BlockPos.MutableBlockPos spawnPosition = player.blockPosition().mutable().move(x, 0, z);
        if (!level.hasChunksAt(spawnPosition.getX() - 10, spawnPosition.getZ() - 10, spawnPosition.getX() + 10, spawnPosition.getZ() + 10)) {
            return 0;
        }
        if (level.getBiome((BlockPos)spawnPosition).is(BiomeTags.WITHOUT_PATROL_SPAWNS)) {
            return 0;
        }
        spawnPosition.setY(level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)spawnPosition).getY());
        this.spawnAmbusher(level, (BlockPos)spawnPosition, level.getRandom());
        return 1;
    }

    private void spawnAmbusher(ServerLevel level, BlockPos spawnPosition, RandomSource random) {
        BlockState blockstate = level.getBlockState(spawnPosition);
        if (!NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)level, (BlockPos)spawnPosition, (BlockState)blockstate, (FluidState)blockstate.getFluidState(), (EntityType)((EntityType)DSEntities.HUNTER_AMBUSHER.get()))) {
            return;
        }
        if (!PatrollingMonster.checkPatrollingMonsterSpawnRules((EntityType)EntityType.PILLAGER, (LevelAccessor)level, (MobSpawnType)MobSpawnType.PATROL, (BlockPos)spawnPosition, (RandomSource)random)) {
            return;
        }
        AmbusherEntity ambusher = (AmbusherEntity)((EntityType)DSEntities.HUNTER_AMBUSHER.get()).create((Level)level);
        if (ambusher == null) {
            return;
        }
        ambusher.setPos(spawnPosition.getX(), spawnPosition.getY(), spawnPosition.getZ());
        EventHooks.finalizeMobSpawn((Mob)ambusher, (ServerLevelAccessor)level, (DifficultyInstance)level.getCurrentDifficultyAt(spawnPosition), (MobSpawnType)MobSpawnType.PATROL, null);
        level.addFreshEntityWithPassengers((Entity)ambusher);
    }

    @SubscribeEvent
    public static void addCustomSpawners(ModifyCustomSpawnersEvent event) {
        event.addCustomSpawner((CustomSpawner)new AmbusherSpawner());
    }
}

