/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.projectile.world_effects;

import by.dragonsurvivalteam.dragonsurvival.registry.projectile.world_effects.ProjectileWorldEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerFunctionManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;

public record ProjectileWorldRunFunctionEffect(ResourceLocation function) implements ProjectileWorldEffect
{
    public static final MapCodec<ProjectileWorldRunFunctionEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("function").forGetter(ProjectileWorldRunFunctionEffect::function)).apply((Applicative)instance, ProjectileWorldRunFunctionEffect::new));

    @Override
    public void apply(Projectile projectile, Void target, int level) {
        ServerLevel serverLevel = (ServerLevel)projectile.level();
        MinecraftServer server = serverLevel.getServer();
        ServerFunctionManager manager = server.getFunctions();
        manager.get(this.function).ifPresent(source -> {
            CommandSourceStack stack = server.createCommandSourceStack().withPermission(2).withSuppressedOutput().withEntity((Entity)projectile).withLevel(serverLevel).withPosition(projectile.position()).withRotation(projectile.getRotationVector());
            manager.execute(source, stack);
        });
    }

    @Override
    public MapCodec<? extends ProjectileWorldEffect> codec() {
        return CODEC;
    }
}

