/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.projectile.world_effects;

import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.world_effects.ProjectileWorldEffect;
import by.dragonsurvivalteam.dragonsurvival.server.handlers.LightningHandler;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.projectile.Projectile;

public record ProjectileLightningWorldEffect(LightningHandler.Data data) implements ProjectileWorldEffect
{
    public static final MapCodec<ProjectileLightningWorldEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LightningHandler.Data.CODEC.fieldOf("data").forGetter(ProjectileLightningWorldEffect::data)).apply((Applicative)instance, ProjectileLightningWorldEffect::new));

    @Override
    public void apply(Projectile projectile, Void target, int level) {
        LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(projectile.level());
        bolt.moveTo(projectile.position());
        Entity entity = projectile.getOwner();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            bolt.setCause(serverPlayer);
        }
        bolt.setData(DSDataAttachments.LIGHTNING_BOLT, (Object)LightningHandler.fromData(this.data));
        projectile.level().addFreshEntity((Entity)bolt);
    }

    @Override
    public MapCodec<? extends ProjectileWorldEffect> codec() {
        return CODEC;
    }
}

