/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.projectile.world_effects;

import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.world_effects.ProjectileWorldEffect;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.Level;

public record ProjectileExplosionEffect(Holder<DamageType> damageType, LevelBasedValue explosionPower, boolean fire, boolean breakBlocks, boolean canDamageSelf) implements ProjectileWorldEffect
{
    @Translation(comments={"\u00a76\u25a0 Explosion Power:\u00a7r %s"})
    private static final String POWER = Translation.Type.GUI.wrap("explosion_effect.power");
    public static final MapCodec<ProjectileExplosionEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DamageType.CODEC.fieldOf("damage_type").forGetter(ProjectileExplosionEffect::damageType), (App)LevelBasedValue.CODEC.fieldOf("explosion_power").forGetter(ProjectileExplosionEffect::explosionPower), (App)Codec.BOOL.fieldOf("fire").forGetter(ProjectileExplosionEffect::fire), (App)Codec.BOOL.fieldOf("break_blocks").forGetter(ProjectileExplosionEffect::breakBlocks), (App)Codec.BOOL.fieldOf("can_damage_self").forGetter(ProjectileExplosionEffect::canDamageSelf)).apply((Applicative)instance, ProjectileExplosionEffect::new));

    @Override
    public void apply(Projectile projectile, Void target, int level) {
        DamageSource source = projectile.getOwner() == null ? new DamageSource(this.damageType, (Entity)projectile, (Entity)projectile) : new DamageSource(this.damageType, (Entity)projectile, projectile.getOwner());
        projectile.level().explode((Entity)(this.canDamageSelf ? projectile : projectile.getOwner()), source, null, projectile.position().x(), projectile.position().y(), projectile.position().z(), this.explosionPower.calculate(level), this.fire, this.breakBlocks ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
    }

    @Override
    public List<MutableComponent> getDescription(Player dragon, int level) {
        return List.of(Component.translatable((String)POWER, (Object[])new Object[]{DSColors.dynamicValue(Float.valueOf(this.explosionPower.calculate(level)))}));
    }

    @Override
    public MapCodec<? extends ProjectileWorldEffect> codec() {
        return CODEC;
    }
}

